/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The new state, variable values, and timer settings of the detector (instance).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorStateDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorStateDefinition.Builder, DetectorStateDefinition> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectorStateDefinition::stateName)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<List<VariableDefinition>> VARIABLES_FIELD = SdkField
            .<List<VariableDefinition>> builder(MarshallingType.LIST)
            .getter(getter(DetectorStateDefinition::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariableDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariableDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TimerDefinition>> TIMERS_FIELD = SdkField
            .<List<TimerDefinition>> builder(MarshallingType.LIST)
            .getter(getter(DetectorStateDefinition::timers))
            .setter(setter(Builder::timers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD,
            VARIABLES_FIELD, TIMERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stateName;

    private final List<VariableDefinition> variables;

    private final List<TimerDefinition> timers;

    private DetectorStateDefinition(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.variables = builder.variables;
        this.timers = builder.timers;
    }

    /**
     * <p>
     * The name of the new state of the detector (instance).
     * </p>
     * 
     * @return The name of the new state of the detector (instance).
     */
    public String stateName() {
        return stateName;
    }

    /**
     * Returns true if the Variables property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new values of the detector's variables. Any variable whose value isn't specified is cleared.
     */
    public List<VariableDefinition> variables() {
        return variables;
    }

    /**
     * Returns true if the Timers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTimers() {
        return timers != null && !(timers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout event
     * won't occur.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTimers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its
     *         timeout event won't occur.
     */
    public List<TimerDefinition> timers() {
        return timers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateName());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        hashCode = 31 * hashCode + Objects.hashCode(timers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorStateDefinition)) {
            return false;
        }
        DetectorStateDefinition other = (DetectorStateDefinition) obj;
        return Objects.equals(stateName(), other.stateName()) && Objects.equals(variables(), other.variables())
                && Objects.equals(timers(), other.timers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectorStateDefinition").add("StateName", stateName()).add("Variables", variables())
                .add("Timers", timers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateName()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "timers":
            return Optional.ofNullable(clazz.cast(timers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorStateDefinition, T> g) {
        return obj -> g.apply((DetectorStateDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorStateDefinition> {
        /**
         * <p>
         * The name of the new state of the detector (instance).
         * </p>
         * 
         * @param stateName
         *        The name of the new state of the detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * </p>
         * 
         * @param variables
         *        The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<VariableDefinition> variables);

        /**
         * <p>
         * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * </p>
         * 
         * @param variables
         *        The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(VariableDefinition... variables);

        /**
         * <p>
         * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VariableDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<VariableDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VariableDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #variables(List<VariableDefinition>)}.
         * 
         * @param variables
         *        a consumer that will call methods on {@link List<VariableDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(List<VariableDefinition>)
         */
        Builder variables(Consumer<VariableDefinition.Builder>... variables);

        /**
         * <p>
         * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout
         * event won't occur.
         * </p>
         * 
         * @param timers
         *        The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its
         *        timeout event won't occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(Collection<TimerDefinition> timers);

        /**
         * <p>
         * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout
         * event won't occur.
         * </p>
         * 
         * @param timers
         *        The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its
         *        timeout event won't occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(TimerDefinition... timers);

        /**
         * <p>
         * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout
         * event won't occur.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TimerDefinition>.Builder} avoiding the need
         * to create one manually via {@link List<TimerDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TimerDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #timers(List<TimerDefinition>)}.
         * 
         * @param timers
         *        a consumer that will call methods on {@link List<TimerDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timers(List<TimerDefinition>)
         */
        Builder timers(Consumer<TimerDefinition.Builder>... timers);
    }

    static final class BuilderImpl implements Builder {
        private String stateName;

        private List<VariableDefinition> variables = DefaultSdkAutoConstructList.getInstance();

        private List<TimerDefinition> timers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorStateDefinition model) {
            stateName(model.stateName);
            variables(model.variables);
            timers(model.timers);
        }

        public final String getStateName() {
            return stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        public final Collection<VariableDefinition.Builder> getVariables() {
            return variables != null ? variables.stream().map(VariableDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variables(Collection<VariableDefinition> variables) {
            this.variables = VariableDefinitionsCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(VariableDefinition... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<VariableDefinition.Builder>... variables) {
            variables(Stream.of(variables).map(c -> VariableDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVariables(Collection<VariableDefinition.BuilderImpl> variables) {
            this.variables = VariableDefinitionsCopier.copyFromBuilder(variables);
        }

        public final Collection<TimerDefinition.Builder> getTimers() {
            return timers != null ? timers.stream().map(TimerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder timers(Collection<TimerDefinition> timers) {
            this.timers = TimerDefinitionsCopier.copy(timers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(TimerDefinition... timers) {
            timers(Arrays.asList(timers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Consumer<TimerDefinition.Builder>... timers) {
            timers(Stream.of(timers).map(c -> TimerDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTimers(Collection<TimerDefinition.BuilderImpl> timers) {
            this.timers = TimerDefinitionsCopier.copyFromBuilder(timers);
        }

        @Override
        public DetectorStateDefinition build() {
            return new DetectorStateDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
