/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.InputStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputConfiguration> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfiguration.getter(InputConfiguration::inputName)).setter(InputConfiguration.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()}).build();
    private static final SdkField<String> INPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfiguration.getter(InputConfiguration::inputDescription)).setter(InputConfiguration.setter(Builder::inputDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDescription").build()}).build();
    private static final SdkField<String> INPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfiguration.getter(InputConfiguration::inputArn)).setter(InputConfiguration.setter(Builder::inputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InputConfiguration.getter(InputConfiguration::creationTime)).setter(InputConfiguration.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InputConfiguration.getter(InputConfiguration::lastUpdateTime)).setter(InputConfiguration.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfiguration.getter(InputConfiguration::statusAsString)).setter(InputConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, INPUT_DESCRIPTION_FIELD, INPUT_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputName;
    private final String inputDescription;
    private final String inputArn;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String status;

    private InputConfiguration(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.inputDescription = builder.inputDescription;
        this.inputArn = builder.inputArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
    }

    public String inputName() {
        return this.inputName;
    }

    public String inputDescription() {
        return this.inputDescription;
    }

    public String inputArn() {
        return this.inputArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public InputStatus status() {
        return InputStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfiguration)) {
            return false;
        }
        InputConfiguration other = (InputConfiguration)obj;
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.inputDescription(), other.inputDescription()) && Objects.equals(this.inputArn(), other.inputArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"InputConfiguration").add("InputName", (Object)this.inputName()).add("InputDescription", (Object)this.inputDescription()).add("InputArn", (Object)this.inputArn()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "inputDescription": {
                return Optional.ofNullable(clazz.cast(this.inputDescription()));
            }
            case "inputArn": {
                return Optional.ofNullable(clazz.cast(this.inputArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfiguration, T> g) {
        return obj -> g.apply((InputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputName;
        private String inputDescription;
        private String inputArn;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfiguration model) {
            this.inputName(model.inputName);
            this.inputDescription(model.inputDescription);
            this.inputArn(model.inputArn);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
        }

        public final String getInputName() {
            return this.inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final String getInputDescription() {
            return this.inputDescription;
        }

        @Override
        public final Builder inputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        public final void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        public final String getInputArn() {
            return this.inputArn;
        }

        @Override
        public final Builder inputArn(String inputArn) {
            this.inputArn = inputArn;
            return this;
        }

        public final void setInputArn(String inputArn) {
            this.inputArn = inputArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InputStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public InputConfiguration build() {
            return new InputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputConfiguration> {
        public Builder inputName(String var1);

        public Builder inputDescription(String var1);

        public Builder inputArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(InputStatus var1);
    }
}

