/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.IotEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDetectorModelRequest
extends IotEventsRequest
implements ToCopyableBuilder<Builder, DescribeDetectorModelRequest> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDetectorModelRequest.getter(DescribeDetectorModelRequest::detectorModelName)).setter(DescribeDetectorModelRequest.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDetectorModelRequest.getter(DescribeDetectorModelRequest::detectorModelVersion)).setter(DescribeDetectorModelRequest.setter(Builder::detectorModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, DETECTOR_MODEL_VERSION_FIELD));
    private final String detectorModelName;
    private final String detectorModelVersion;

    private DescribeDetectorModelRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelVersion = builder.detectorModelVersion;
    }

    public String detectorModelName() {
        return this.detectorModelName;
    }

    public String detectorModelVersion() {
        return this.detectorModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorModelRequest)) {
            return false;
        }
        DescribeDetectorModelRequest other = (DescribeDetectorModelRequest)((Object)obj);
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.detectorModelVersion(), other.detectorModelVersion());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDetectorModelRequest").add("DetectorModelName", (Object)this.detectorModelName()).add("DetectorModelVersion", (Object)this.detectorModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "detectorModelVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorModelVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorModelRequest, T> g) {
        return obj -> g.apply((DescribeDetectorModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsRequest.BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String detectorModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorModelRequest model) {
            super(model);
            this.detectorModelName(model.detectorModelName);
            this.detectorModelVersion(model.detectorModelVersion);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getDetectorModelVersion() {
            return this.detectorModelVersion;
        }

        @Override
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDetectorModelRequest build() {
            return new DescribeDetectorModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDetectorModelRequest> {
        public Builder detectorModelName(String var1);

        public Builder detectorModelVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

