/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.DetectorModelDefinition;
import software.amazon.awssdk.services.iotevents.model.IotEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDetectorModelRequest
extends IotEventsRequest
implements ToCopyableBuilder<Builder, UpdateDetectorModelRequest> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDetectorModelRequest.getter(UpdateDetectorModelRequest::detectorModelName)).setter(UpdateDetectorModelRequest.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorModelName").build()}).build();
    private static final SdkField<DetectorModelDefinition> DETECTOR_MODEL_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDetectorModelRequest.getter(UpdateDetectorModelRequest::detectorModelDefinition)).setter(UpdateDetectorModelRequest.setter(Builder::detectorModelDefinition)).constructor(DetectorModelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDefinition").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDetectorModelRequest.getter(UpdateDetectorModelRequest::detectorModelDescription)).setter(UpdateDetectorModelRequest.setter(Builder::detectorModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDetectorModelRequest.getter(UpdateDetectorModelRequest::roleArn)).setter(UpdateDetectorModelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, DETECTOR_MODEL_DEFINITION_FIELD, DETECTOR_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD));
    private final String detectorModelName;
    private final DetectorModelDefinition detectorModelDefinition;
    private final String detectorModelDescription;
    private final String roleArn;

    private UpdateDetectorModelRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelDefinition = builder.detectorModelDefinition;
        this.detectorModelDescription = builder.detectorModelDescription;
        this.roleArn = builder.roleArn;
    }

    public String detectorModelName() {
        return this.detectorModelName;
    }

    public DetectorModelDefinition detectorModelDefinition() {
        return this.detectorModelDefinition;
    }

    public String detectorModelDescription() {
        return this.detectorModelDescription;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorModelRequest)) {
            return false;
        }
        UpdateDetectorModelRequest other = (UpdateDetectorModelRequest)((Object)obj);
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.detectorModelDefinition(), other.detectorModelDefinition()) && Objects.equals(this.detectorModelDescription(), other.detectorModelDescription()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDetectorModelRequest").add("DetectorModelName", (Object)this.detectorModelName()).add("DetectorModelDefinition", (Object)this.detectorModelDefinition()).add("DetectorModelDescription", (Object)this.detectorModelDescription()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "detectorModelDefinition": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDefinition()));
            }
            case "detectorModelDescription": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDescription()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorModelRequest, T> g) {
        return obj -> g.apply((UpdateDetectorModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsRequest.BuilderImpl
    implements Builder {
        private String detectorModelName;
        private DetectorModelDefinition detectorModelDefinition;
        private String detectorModelDescription;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorModelRequest model) {
            super(model);
            this.detectorModelName(model.detectorModelName);
            this.detectorModelDefinition(model.detectorModelDefinition);
            this.detectorModelDescription(model.detectorModelDescription);
            this.roleArn(model.roleArn);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final DetectorModelDefinition.Builder getDetectorModelDefinition() {
            return this.detectorModelDefinition != null ? this.detectorModelDefinition.toBuilder() : null;
        }

        @Override
        public final Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        public final void setDetectorModelDefinition(DetectorModelDefinition.BuilderImpl detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition != null ? detectorModelDefinition.build() : null;
        }

        public final String getDetectorModelDescription() {
            return this.detectorModelDescription;
        }

        @Override
        public final Builder detectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        public final void setDetectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorModelRequest build() {
            return new UpdateDetectorModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDetectorModelRequest> {
        public Builder detectorModelName(String var1);

        public Builder detectorModelDefinition(DetectorModelDefinition var1);

        default public Builder detectorModelDefinition(Consumer<DetectorModelDefinition.Builder> detectorModelDefinition) {
            return this.detectorModelDefinition((DetectorModelDefinition)((DetectorModelDefinition.Builder)DetectorModelDefinition.builder().applyMutation(detectorModelDefinition)).build());
        }

        public Builder detectorModelDescription(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

