/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.DetectorModelConfiguration;
import software.amazon.awssdk.services.iotevents.model.DetectorModelDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorModel> {
    private static final SdkField<DetectorModelDefinition> DETECTOR_MODEL_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetectorModel.getter(DetectorModel::detectorModelDefinition)).setter(DetectorModel.setter(Builder::detectorModelDefinition)).constructor(DetectorModelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDefinition").build()}).build();
    private static final SdkField<DetectorModelConfiguration> DETECTOR_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetectorModel.getter(DetectorModel::detectorModelConfiguration)).setter(DetectorModel.setter(Builder::detectorModelConfiguration)).constructor(DetectorModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_DEFINITION_FIELD, DETECTOR_MODEL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final DetectorModelDefinition detectorModelDefinition;
    private final DetectorModelConfiguration detectorModelConfiguration;

    private DetectorModel(BuilderImpl builder) {
        this.detectorModelDefinition = builder.detectorModelDefinition;
        this.detectorModelConfiguration = builder.detectorModelConfiguration;
    }

    public DetectorModelDefinition detectorModelDefinition() {
        return this.detectorModelDefinition;
    }

    public DetectorModelConfiguration detectorModelConfiguration() {
        return this.detectorModelConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModel)) {
            return false;
        }
        DetectorModel other = (DetectorModel)obj;
        return Objects.equals(this.detectorModelDefinition(), other.detectorModelDefinition()) && Objects.equals(this.detectorModelConfiguration(), other.detectorModelConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"DetectorModel").add("DetectorModelDefinition", (Object)this.detectorModelDefinition()).add("DetectorModelConfiguration", (Object)this.detectorModelConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelDefinition": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDefinition()));
            }
            case "detectorModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.detectorModelConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModel, T> g) {
        return obj -> g.apply((DetectorModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DetectorModelDefinition detectorModelDefinition;
        private DetectorModelConfiguration detectorModelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModel model) {
            this.detectorModelDefinition(model.detectorModelDefinition);
            this.detectorModelConfiguration(model.detectorModelConfiguration);
        }

        public final DetectorModelDefinition.Builder getDetectorModelDefinition() {
            return this.detectorModelDefinition != null ? this.detectorModelDefinition.toBuilder() : null;
        }

        @Override
        public final Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        public final void setDetectorModelDefinition(DetectorModelDefinition.BuilderImpl detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition != null ? detectorModelDefinition.build() : null;
        }

        public final DetectorModelConfiguration.Builder getDetectorModelConfiguration() {
            return this.detectorModelConfiguration != null ? this.detectorModelConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder detectorModelConfiguration(DetectorModelConfiguration detectorModelConfiguration) {
            this.detectorModelConfiguration = detectorModelConfiguration;
            return this;
        }

        public final void setDetectorModelConfiguration(DetectorModelConfiguration.BuilderImpl detectorModelConfiguration) {
            this.detectorModelConfiguration = detectorModelConfiguration != null ? detectorModelConfiguration.build() : null;
        }

        public DetectorModel build() {
            return new DetectorModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorModel> {
        public Builder detectorModelDefinition(DetectorModelDefinition var1);

        default public Builder detectorModelDefinition(Consumer<DetectorModelDefinition.Builder> detectorModelDefinition) {
            return this.detectorModelDefinition((DetectorModelDefinition)((DetectorModelDefinition.Builder)DetectorModelDefinition.builder().applyMutation(detectorModelDefinition)).build());
        }

        public Builder detectorModelConfiguration(DetectorModelConfiguration var1);

        default public Builder detectorModelConfiguration(Consumer<DetectorModelConfiguration.Builder> detectorModelConfiguration) {
            return this.detectorModelConfiguration((DetectorModelConfiguration)((DetectorModelConfiguration.Builder)DetectorModelConfiguration.builder().applyMutation(detectorModelConfiguration)).build());
        }
    }
}

