/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluationMethod {
    BATCH("BATCH"),
    SERIAL("SERIAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationMethod> VALUE_MAP;
    private final String value;

    private EvaluationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluationMethod> knownValues() {
        EnumSet<EvaluationMethod> knownValues = EnumSet.allOf(EvaluationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluationMethod.class, EvaluationMethod::toString);
    }
}

