/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdeviceadvisor.DefaultIotDeviceAdvisorBaseClientBuilder;
import software.amazon.awssdk.services.iotdeviceadvisor.DefaultIotDeviceAdvisorClient;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorClient;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorClientBuilder;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorServiceClientConfiguration;
import software.amazon.awssdk.services.iotdeviceadvisor.endpoints.IotDeviceAdvisorEndpointProvider;

@SdkInternalApi
final class DefaultIotDeviceAdvisorClientBuilder
extends DefaultIotDeviceAdvisorBaseClientBuilder<IotDeviceAdvisorClientBuilder, IotDeviceAdvisorClient>
implements IotDeviceAdvisorClientBuilder {
    DefaultIotDeviceAdvisorClientBuilder() {
    }

    @Override
    public DefaultIotDeviceAdvisorClientBuilder endpointProvider(IotDeviceAdvisorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotDeviceAdvisorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotDeviceAdvisorClientBuilder.validateClientOptions(clientConfiguration);
        IotDeviceAdvisorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotDeviceAdvisorClient client = new DefaultIotDeviceAdvisorClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotDeviceAdvisorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotDeviceAdvisorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

