/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCase;

final class TestCaseListCopier {
    TestCaseListCopier() {
    }

    static List<TestCase> copy(Collection<? extends TestCase> testCaseListParam) {
        Object list;
        if (testCaseListParam == null || testCaseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            testCaseListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TestCase> copyFromBuilder(Collection<? extends TestCase.Builder> testCaseListParam) {
        Object list;
        if (testCaseListParam == null || testCaseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            testCaseListParam.forEach(entry -> {
                TestCase member = (TestCase)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TestCase.Builder> copyToBuilder(Collection<? extends TestCase> testCaseListParam) {
        Object list;
        if (testCaseListParam == null || testCaseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            testCaseListParam.forEach(entry -> {
                TestCase.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

