/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorClient;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTestCasesRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTestCasesResponse;

public class ListTestCasesIterable
implements SdkIterable<ListTestCasesResponse> {
    private final IotDeviceAdvisorClient client;
    private final ListTestCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestCasesIterable(IotDeviceAdvisorClient client, ListTestCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestCasesResponseFetcher();
    }

    public Iterator<ListTestCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestCasesResponseFetcher
    implements SyncPageFetcher<ListTestCasesResponse> {
        private ListTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestCasesResponse nextPage(ListTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListTestCasesIterable.this.client.listTestCases(ListTestCasesIterable.this.firstRequest);
            }
            return ListTestCasesIterable.this.client.listTestCases((ListTestCasesRequest)((Object)ListTestCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

