/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides test case run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseRun implements SdkPojo, Serializable, ToCopyableBuilder<TestCaseRun.Builder, TestCaseRun> {
    private static final SdkField<String> TEST_CASE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseRunId").getter(getter(TestCaseRun::testCaseRunId)).setter(setter(Builder::testCaseRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseRunId").build()).build();

    private static final SdkField<String> TEST_CASE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseDefinitionId").getter(getter(TestCaseRun::testCaseDefinitionId))
            .setter(setter(Builder::testCaseDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseDefinitionId").build())
            .build();

    private static final SdkField<String> TEST_CASE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseDefinitionName").getter(getter(TestCaseRun::testCaseDefinitionName))
            .setter(setter(Builder::testCaseDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseDefinitionName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestCaseRun::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(TestCaseRun::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(TestCaseRun::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUrl")
            .getter(getter(TestCaseRun::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()).build();

    private static final SdkField<String> WARNINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warnings").getter(getter(TestCaseRun::warnings)).setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build()).build();

    private static final SdkField<String> FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("failure")
            .getter(getter(TestCaseRun::failure)).setter(setter(Builder::failure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_RUN_ID_FIELD,
            TEST_CASE_DEFINITION_ID_FIELD, TEST_CASE_DEFINITION_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            LOG_URL_FIELD, WARNINGS_FIELD, FAILURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String testCaseRunId;

    private final String testCaseDefinitionId;

    private final String testCaseDefinitionName;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final String logUrl;

    private final String warnings;

    private final String failure;

    private TestCaseRun(BuilderImpl builder) {
        this.testCaseRunId = builder.testCaseRunId;
        this.testCaseDefinitionId = builder.testCaseDefinitionId;
        this.testCaseDefinitionName = builder.testCaseDefinitionName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.logUrl = builder.logUrl;
        this.warnings = builder.warnings;
        this.failure = builder.failure;
    }

    /**
     * <p>
     * Provides test case run Id.
     * </p>
     * 
     * @return Provides test case run Id.
     */
    public final String testCaseRunId() {
        return testCaseRunId;
    }

    /**
     * <p>
     * Provides test case run definition Id.
     * </p>
     * 
     * @return Provides test case run definition Id.
     */
    public final String testCaseDefinitionId() {
        return testCaseDefinitionId;
    }

    /**
     * <p>
     * Provides test case run definition Name.
     * </p>
     * 
     * @return Provides test case run definition Name.
     */
    public final String testCaseDefinitionName() {
        return testCaseDefinitionName;
    }

    /**
     * <p>
     * Provides test case run status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Provides test case run status.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Provides test case run status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Provides test case run status.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides test case run start time.
     * </p>
     * 
     * @return Provides test case run start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Provides test case run end time.
     * </p>
     * 
     * @return Provides test case run end time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Provides test case run log Url.
     * </p>
     * 
     * @return Provides test case run log Url.
     */
    public final String logUrl() {
        return logUrl;
    }

    /**
     * <p>
     * Provides test case run warnings.
     * </p>
     * 
     * @return Provides test case run warnings.
     */
    public final String warnings() {
        return warnings;
    }

    /**
     * <p>
     * Provides test case run failure result.
     * </p>
     * 
     * @return Provides test case run failure result.
     */
    public final String failure() {
        return failure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCaseRunId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(warnings());
        hashCode = 31 * hashCode + Objects.hashCode(failure());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseRun)) {
            return false;
        }
        TestCaseRun other = (TestCaseRun) obj;
        return Objects.equals(testCaseRunId(), other.testCaseRunId())
                && Objects.equals(testCaseDefinitionId(), other.testCaseDefinitionId())
                && Objects.equals(testCaseDefinitionName(), other.testCaseDefinitionName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(logUrl(), other.logUrl())
                && Objects.equals(warnings(), other.warnings()) && Objects.equals(failure(), other.failure());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseRun").add("TestCaseRunId", testCaseRunId())
                .add("TestCaseDefinitionId", testCaseDefinitionId()).add("TestCaseDefinitionName", testCaseDefinitionName())
                .add("Status", statusAsString()).add("StartTime", startTime()).add("EndTime", endTime()).add("LogUrl", logUrl())
                .add("Warnings", warnings()).add("Failure", failure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseRunId":
            return Optional.ofNullable(clazz.cast(testCaseRunId()));
        case "testCaseDefinitionId":
            return Optional.ofNullable(clazz.cast(testCaseDefinitionId()));
        case "testCaseDefinitionName":
            return Optional.ofNullable(clazz.cast(testCaseDefinitionName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "logUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "failure":
            return Optional.ofNullable(clazz.cast(failure()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCaseRun, T> g) {
        return obj -> g.apply((TestCaseRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseRun> {
        /**
         * <p>
         * Provides test case run Id.
         * </p>
         * 
         * @param testCaseRunId
         *        Provides test case run Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseRunId(String testCaseRunId);

        /**
         * <p>
         * Provides test case run definition Id.
         * </p>
         * 
         * @param testCaseDefinitionId
         *        Provides test case run definition Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseDefinitionId(String testCaseDefinitionId);

        /**
         * <p>
         * Provides test case run definition Name.
         * </p>
         * 
         * @param testCaseDefinitionName
         *        Provides test case run definition Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseDefinitionName(String testCaseDefinitionName);

        /**
         * <p>
         * Provides test case run status.
         * </p>
         * 
         * @param status
         *        Provides test case run status.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Provides test case run status.
         * </p>
         * 
         * @param status
         *        Provides test case run status.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Provides test case run start time.
         * </p>
         * 
         * @param startTime
         *        Provides test case run start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Provides test case run end time.
         * </p>
         * 
         * @param endTime
         *        Provides test case run end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Provides test case run log Url.
         * </p>
         * 
         * @param logUrl
         *        Provides test case run log Url.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);

        /**
         * <p>
         * Provides test case run warnings.
         * </p>
         * 
         * @param warnings
         *        Provides test case run warnings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String warnings);

        /**
         * <p>
         * Provides test case run failure result.
         * </p>
         * 
         * @param failure
         *        Provides test case run failure result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failure(String failure);
    }

    static final class BuilderImpl implements Builder {
        private String testCaseRunId;

        private String testCaseDefinitionId;

        private String testCaseDefinitionName;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private String logUrl;

        private String warnings;

        private String failure;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseRun model) {
            testCaseRunId(model.testCaseRunId);
            testCaseDefinitionId(model.testCaseDefinitionId);
            testCaseDefinitionName(model.testCaseDefinitionName);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            logUrl(model.logUrl);
            warnings(model.warnings);
            failure(model.failure);
        }

        public final String getTestCaseRunId() {
            return testCaseRunId;
        }

        @Override
        public final Builder testCaseRunId(String testCaseRunId) {
            this.testCaseRunId = testCaseRunId;
            return this;
        }

        public final void setTestCaseRunId(String testCaseRunId) {
            this.testCaseRunId = testCaseRunId;
        }

        public final String getTestCaseDefinitionId() {
            return testCaseDefinitionId;
        }

        @Override
        public final Builder testCaseDefinitionId(String testCaseDefinitionId) {
            this.testCaseDefinitionId = testCaseDefinitionId;
            return this;
        }

        public final void setTestCaseDefinitionId(String testCaseDefinitionId) {
            this.testCaseDefinitionId = testCaseDefinitionId;
        }

        public final String getTestCaseDefinitionName() {
            return testCaseDefinitionName;
        }

        @Override
        public final Builder testCaseDefinitionName(String testCaseDefinitionName) {
            this.testCaseDefinitionName = testCaseDefinitionName;
            return this;
        }

        public final void setTestCaseDefinitionName(String testCaseDefinitionName) {
            this.testCaseDefinitionName = testCaseDefinitionName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public final String getWarnings() {
            return warnings;
        }

        @Override
        public final Builder warnings(String warnings) {
            this.warnings = warnings;
            return this;
        }

        public final void setWarnings(String warnings) {
            this.warnings = warnings;
        }

        public final String getFailure() {
            return failure;
        }

        @Override
        public final Builder failure(String failure) {
            this.failure = failure;
            return this;
        }

        public final void setFailure(String failure) {
            this.failure = failure;
        }

        @Override
        public TestCaseRun build() {
            return new TestCaseRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
