/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestCasesResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<ListTestCasesResponse.Builder, ListTestCasesResponse> {
    private static final SdkField<List<TestCaseCategory>> CATEGORIES_FIELD = SdkField
            .<List<TestCaseCategory>> builder(MarshallingType.LIST)
            .memberName("categories")
            .getter(getter(ListTestCasesResponse::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCaseCategory> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCaseCategory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ROOT_GROUP_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("rootGroupConfiguration")
            .getter(getter(ListTestCasesResponse::rootGroupConfiguration))
            .setter(setter(Builder::rootGroupConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootGroupConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> GROUP_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("groupConfiguration")
            .getter(getter(ListTestCasesResponse::groupConfiguration))
            .setter(setter(Builder::groupConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD,
            ROOT_GROUP_CONFIGURATION_FIELD, GROUP_CONFIGURATION_FIELD, NEXT_TOKEN_FIELD));

    private final List<TestCaseCategory> categories;

    private final Map<String, String> rootGroupConfiguration;

    private final Map<String, String> groupConfiguration;

    private final String nextToken;

    private ListTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.categories = builder.categories;
        this.rootGroupConfiguration = builder.rootGroupConfiguration;
        this.groupConfiguration = builder.groupConfiguration;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Categories property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets the category of test case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Gets the category of test case.
     */
    public final List<TestCaseCategory> categories() {
        return categories;
    }

    /**
     * Returns true if the RootGroupConfiguration property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRootGroupConfiguration() {
        return rootGroupConfiguration != null && !(rootGroupConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Gets the configuration of root test group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRootGroupConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Gets the configuration of root test group.
     */
    public final Map<String, String> rootGroupConfiguration() {
        return rootGroupConfiguration;
    }

    /**
     * Returns true if the GroupConfiguration property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGroupConfiguration() {
        return groupConfiguration != null && !(groupConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Gets the configuration of test group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Gets the configuration of test group.
     */
    public final Map<String, String> groupConfiguration() {
        return groupConfiguration;
    }

    /**
     * <p>
     * Test cases next token response.
     * </p>
     * 
     * @return Test cases next token response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRootGroupConfiguration() ? rootGroupConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupConfiguration() ? groupConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestCasesResponse)) {
            return false;
        }
        ListTestCasesResponse other = (ListTestCasesResponse) obj;
        return hasCategories() == other.hasCategories() && Objects.equals(categories(), other.categories())
                && hasRootGroupConfiguration() == other.hasRootGroupConfiguration()
                && Objects.equals(rootGroupConfiguration(), other.rootGroupConfiguration())
                && hasGroupConfiguration() == other.hasGroupConfiguration()
                && Objects.equals(groupConfiguration(), other.groupConfiguration())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestCasesResponse").add("Categories", hasCategories() ? categories() : null)
                .add("RootGroupConfiguration", hasRootGroupConfiguration() ? rootGroupConfiguration() : null)
                .add("GroupConfiguration", hasGroupConfiguration() ? groupConfiguration() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "rootGroupConfiguration":
            return Optional.ofNullable(clazz.cast(rootGroupConfiguration()));
        case "groupConfiguration":
            return Optional.ofNullable(clazz.cast(groupConfiguration()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestCasesResponse, T> g) {
        return obj -> g.apply((ListTestCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTestCasesResponse> {
        /**
         * <p>
         * Gets the category of test case.
         * </p>
         * 
         * @param categories
         *        Gets the category of test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<TestCaseCategory> categories);

        /**
         * <p>
         * Gets the category of test case.
         * </p>
         * 
         * @param categories
         *        Gets the category of test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(TestCaseCategory... categories);

        /**
         * <p>
         * Gets the category of test case.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestCaseCategory>.Builder} avoiding the
         * need to create one manually via {@link List<TestCaseCategory>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestCaseCategory>.Builder#build()} is called immediately and
         * its result is passed to {@link #categories(List<TestCaseCategory>)}.
         * 
         * @param categories
         *        a consumer that will call methods on {@link List<TestCaseCategory>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(List<TestCaseCategory>)
         */
        Builder categories(Consumer<TestCaseCategory.Builder>... categories);

        /**
         * <p>
         * Gets the configuration of root test group.
         * </p>
         * 
         * @param rootGroupConfiguration
         *        Gets the configuration of root test group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootGroupConfiguration(Map<String, String> rootGroupConfiguration);

        /**
         * <p>
         * Gets the configuration of test group.
         * </p>
         * 
         * @param groupConfiguration
         *        Gets the configuration of test group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupConfiguration(Map<String, String> groupConfiguration);

        /**
         * <p>
         * Test cases next token response.
         * </p>
         * 
         * @param nextToken
         *        Test cases next token response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private List<TestCaseCategory> categories = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> rootGroupConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> groupConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestCasesResponse model) {
            super(model);
            categories(model.categories);
            rootGroupConfiguration(model.rootGroupConfiguration);
            groupConfiguration(model.groupConfiguration);
            nextToken(model.nextToken);
        }

        public final Collection<TestCaseCategory.Builder> getCategories() {
            if (categories instanceof SdkAutoConstructList) {
                return null;
            }
            return categories != null ? categories.stream().map(TestCaseCategory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categories(Collection<TestCaseCategory> categories) {
            this.categories = TestCategoryCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(TestCaseCategory... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<TestCaseCategory.Builder>... categories) {
            categories(Stream.of(categories).map(c -> TestCaseCategory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCategories(Collection<TestCaseCategory.BuilderImpl> categories) {
            this.categories = TestCategoryCopier.copyFromBuilder(categories);
        }

        public final Map<String, String> getRootGroupConfiguration() {
            if (rootGroupConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return rootGroupConfiguration;
        }

        @Override
        public final Builder rootGroupConfiguration(Map<String, String> rootGroupConfiguration) {
            this.rootGroupConfiguration = TestConfigurationCopier.copy(rootGroupConfiguration);
            return this;
        }

        public final void setRootGroupConfiguration(Map<String, String> rootGroupConfiguration) {
            this.rootGroupConfiguration = TestConfigurationCopier.copy(rootGroupConfiguration);
        }

        public final Map<String, String> getGroupConfiguration() {
            if (groupConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return groupConfiguration;
        }

        @Override
        public final Builder groupConfiguration(Map<String, String> groupConfiguration) {
            this.groupConfiguration = TestConfigurationCopier.copy(groupConfiguration);
            return this;
        }

        public final void setGroupConfiguration(Map<String, String> groupConfiguration) {
            this.groupConfiguration = TestConfigurationCopier.copy(groupConfiguration);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestCasesResponse build() {
            return new ListTestCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
