/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSuiteDefinitionsResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<ListSuiteDefinitionsResponse.Builder, ListSuiteDefinitionsResponse> {
    private static final SdkField<List<SuiteDefinitionInformation>> SUITE_DEFINITION_INFORMATION_LIST_FIELD = SdkField
            .<List<SuiteDefinitionInformation>> builder(MarshallingType.LIST)
            .memberName("suiteDefinitionInformationList")
            .getter(getter(ListSuiteDefinitionsResponse::suiteDefinitionInformationList))
            .setter(setter(Builder::suiteDefinitionInformationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionInformationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuiteDefinitionInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuiteDefinitionInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSuiteDefinitionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUITE_DEFINITION_INFORMATION_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<SuiteDefinitionInformation> suiteDefinitionInformationList;

    private final String nextToken;

    private ListSuiteDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionInformationList = builder.suiteDefinitionInformationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SuiteDefinitionInformationList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasSuiteDefinitionInformationList() {
        return suiteDefinitionInformationList != null && !(suiteDefinitionInformationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists test suite information using List suite definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuiteDefinitionInformationList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists test suite information using List suite definition.
     */
    public final List<SuiteDefinitionInformation> suiteDefinitionInformationList() {
        return suiteDefinitionInformationList;
    }

    /**
     * <p>
     * Creates a Device Advisor test suite.
     * </p>
     * 
     * @return Creates a Device Advisor test suite.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSuiteDefinitionInformationList() ? suiteDefinitionInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuiteDefinitionsResponse)) {
            return false;
        }
        ListSuiteDefinitionsResponse other = (ListSuiteDefinitionsResponse) obj;
        return hasSuiteDefinitionInformationList() == other.hasSuiteDefinitionInformationList()
                && Objects.equals(suiteDefinitionInformationList(), other.suiteDefinitionInformationList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListSuiteDefinitionsResponse")
                .add("SuiteDefinitionInformationList",
                        hasSuiteDefinitionInformationList() ? suiteDefinitionInformationList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionInformationList":
            return Optional.ofNullable(clazz.cast(suiteDefinitionInformationList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuiteDefinitionsResponse, T> g) {
        return obj -> g.apply((ListSuiteDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSuiteDefinitionsResponse> {
        /**
         * <p>
         * Lists test suite information using List suite definition.
         * </p>
         * 
         * @param suiteDefinitionInformationList
         *        Lists test suite information using List suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionInformationList(Collection<SuiteDefinitionInformation> suiteDefinitionInformationList);

        /**
         * <p>
         * Lists test suite information using List suite definition.
         * </p>
         * 
         * @param suiteDefinitionInformationList
         *        Lists test suite information using List suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionInformationList(SuiteDefinitionInformation... suiteDefinitionInformationList);

        /**
         * <p>
         * Lists test suite information using List suite definition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SuiteDefinitionInformation>.Builder}
         * avoiding the need to create one manually via {@link List<SuiteDefinitionInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuiteDefinitionInformation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #suiteDefinitionInformationList(List<SuiteDefinitionInformation>)}.
         * 
         * @param suiteDefinitionInformationList
         *        a consumer that will call methods on {@link List<SuiteDefinitionInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteDefinitionInformationList(List<SuiteDefinitionInformation>)
         */
        Builder suiteDefinitionInformationList(Consumer<SuiteDefinitionInformation.Builder>... suiteDefinitionInformationList);

        /**
         * <p>
         * Creates a Device Advisor test suite.
         * </p>
         * 
         * @param nextToken
         *        Creates a Device Advisor test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private List<SuiteDefinitionInformation> suiteDefinitionInformationList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuiteDefinitionsResponse model) {
            super(model);
            suiteDefinitionInformationList(model.suiteDefinitionInformationList);
            nextToken(model.nextToken);
        }

        public final Collection<SuiteDefinitionInformation.Builder> getSuiteDefinitionInformationList() {
            if (suiteDefinitionInformationList instanceof SdkAutoConstructList) {
                return null;
            }
            return suiteDefinitionInformationList != null ? suiteDefinitionInformationList.stream()
                    .map(SuiteDefinitionInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suiteDefinitionInformationList(Collection<SuiteDefinitionInformation> suiteDefinitionInformationList) {
            this.suiteDefinitionInformationList = SuiteDefinitionInformationListCopier.copy(suiteDefinitionInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suiteDefinitionInformationList(SuiteDefinitionInformation... suiteDefinitionInformationList) {
            suiteDefinitionInformationList(Arrays.asList(suiteDefinitionInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suiteDefinitionInformationList(
                Consumer<SuiteDefinitionInformation.Builder>... suiteDefinitionInformationList) {
            suiteDefinitionInformationList(Stream.of(suiteDefinitionInformationList)
                    .map(c -> SuiteDefinitionInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuiteDefinitionInformationList(
                Collection<SuiteDefinitionInformation.BuilderImpl> suiteDefinitionInformationList) {
            this.suiteDefinitionInformationList = SuiteDefinitionInformationListCopier
                    .copyFromBuilder(suiteDefinitionInformationList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSuiteDefinitionsResponse build() {
            return new ListSuiteDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
