/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Show Group Result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupResult implements SdkPojo, Serializable, ToCopyableBuilder<GroupResult.Builder, GroupResult> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupId").getter(getter(GroupResult::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupName").getter(getter(GroupResult::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<List<TestCaseRun>> TESTS_FIELD = SdkField
            .<List<TestCaseRun>> builder(MarshallingType.LIST)
            .memberName("tests")
            .getter(getter(GroupResult::tests))
            .setter(setter(Builder::tests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCaseRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCaseRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            GROUP_NAME_FIELD, TESTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String groupName;

    private final List<TestCaseRun> tests;

    private GroupResult(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.tests = builder.tests;
    }

    /**
     * <p>
     * Show Group Result Id.
     * </p>
     * 
     * @return Show Group Result Id.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * Show Group Result Name.
     * </p>
     * 
     * @return Show Group Result Name.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * Returns true if the Tests property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTests() {
        return tests != null && !(tests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Show Group Result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Show Group Result.
     */
    public final List<TestCaseRun> tests() {
        return tests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTests() ? tests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResult)) {
            return false;
        }
        GroupResult other = (GroupResult) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName())
                && hasTests() == other.hasTests() && Objects.equals(tests(), other.tests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupResult").add("GroupId", groupId()).add("GroupName", groupName())
                .add("Tests", hasTests() ? tests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "tests":
            return Optional.ofNullable(clazz.cast(tests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupResult, T> g) {
        return obj -> g.apply((GroupResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupResult> {
        /**
         * <p>
         * Show Group Result Id.
         * </p>
         * 
         * @param groupId
         *        Show Group Result Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Show Group Result Name.
         * </p>
         * 
         * @param groupName
         *        Show Group Result Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Show Group Result.
         * </p>
         * 
         * @param tests
         *        Show Group Result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tests(Collection<TestCaseRun> tests);

        /**
         * <p>
         * Show Group Result.
         * </p>
         * 
         * @param tests
         *        Show Group Result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tests(TestCaseRun... tests);

        /**
         * <p>
         * Show Group Result.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestCaseRun>.Builder} avoiding the need to
         * create one manually via {@link List<TestCaseRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestCaseRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #tests(List<TestCaseRun>)}.
         * 
         * @param tests
         *        a consumer that will call methods on {@link List<TestCaseRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tests(List<TestCaseRun>)
         */
        Builder tests(Consumer<TestCaseRun.Builder>... tests);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private List<TestCaseRun> tests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupResult model) {
            groupId(model.groupId);
            groupName(model.groupName);
            tests(model.tests);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<TestCaseRun.Builder> getTests() {
            if (tests instanceof SdkAutoConstructList) {
                return null;
            }
            return tests != null ? tests.stream().map(TestCaseRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tests(Collection<TestCaseRun> tests) {
            this.tests = TestCaseRunsCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(TestCaseRun... tests) {
            tests(Arrays.asList(tests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Consumer<TestCaseRun.Builder>... tests) {
            tests(Stream.of(tests).map(c -> TestCaseRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTests(Collection<TestCaseRun.BuilderImpl> tests) {
            this.tests = TestCaseRunsCopier.copyFromBuilder(tests);
        }

        @Override
        public GroupResult build() {
            return new GroupResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
