/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseCategory;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCategoryCopier;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestCasesResponse
extends IotDeviceAdvisorResponse
implements ToCopyableBuilder<Builder, ListTestCasesResponse> {
    private static final SdkField<List<TestCaseCategory>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categories").getter(ListTestCasesResponse.getter(ListTestCasesResponse::categories)).setter(ListTestCasesResponse.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestCaseCategory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ROOT_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("rootGroupConfiguration").getter(ListTestCasesResponse.getter(ListTestCasesResponse::rootGroupConfiguration)).setter(ListTestCasesResponse.setter(Builder::rootGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootGroupConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("groupConfiguration").getter(ListTestCasesResponse.getter(ListTestCasesResponse::groupConfiguration)).setter(ListTestCasesResponse.setter(Builder::groupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestCasesResponse.getter(ListTestCasesResponse::nextToken)).setter(ListTestCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD, ROOT_GROUP_CONFIGURATION_FIELD, GROUP_CONFIGURATION_FIELD, NEXT_TOKEN_FIELD));
    private final List<TestCaseCategory> categories;
    private final Map<String, String> rootGroupConfiguration;
    private final Map<String, String> groupConfiguration;
    private final String nextToken;

    private ListTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.categories = builder.categories;
        this.rootGroupConfiguration = builder.rootGroupConfiguration;
        this.groupConfiguration = builder.groupConfiguration;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public List<TestCaseCategory> categories() {
        return this.categories;
    }

    public boolean hasRootGroupConfiguration() {
        return this.rootGroupConfiguration != null && !(this.rootGroupConfiguration instanceof SdkAutoConstructMap);
    }

    public Map<String, String> rootGroupConfiguration() {
        return this.rootGroupConfiguration;
    }

    public boolean hasGroupConfiguration() {
        return this.groupConfiguration != null && !(this.groupConfiguration instanceof SdkAutoConstructMap);
    }

    public Map<String, String> groupConfiguration() {
        return this.groupConfiguration;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRootGroupConfiguration() ? this.rootGroupConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupConfiguration() ? this.groupConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestCasesResponse)) {
            return false;
        }
        ListTestCasesResponse other = (ListTestCasesResponse)((Object)obj);
        return this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && this.hasRootGroupConfiguration() == other.hasRootGroupConfiguration() && Objects.equals(this.rootGroupConfiguration(), other.rootGroupConfiguration()) && this.hasGroupConfiguration() == other.hasGroupConfiguration() && Objects.equals(this.groupConfiguration(), other.groupConfiguration()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTestCasesResponse").add("Categories", this.hasCategories() ? this.categories() : null).add("RootGroupConfiguration", this.hasRootGroupConfiguration() ? this.rootGroupConfiguration() : null).add("GroupConfiguration", this.hasGroupConfiguration() ? this.groupConfiguration() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "rootGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rootGroupConfiguration()));
            }
            case "groupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupConfiguration()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestCasesResponse, T> g) {
        return obj -> g.apply((ListTestCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorResponse.BuilderImpl
    implements Builder {
        private List<TestCaseCategory> categories = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> rootGroupConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> groupConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestCasesResponse model) {
            super(model);
            this.categories(model.categories);
            this.rootGroupConfiguration(model.rootGroupConfiguration);
            this.groupConfiguration(model.groupConfiguration);
            this.nextToken(model.nextToken);
        }

        public final Collection<TestCaseCategory.Builder> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories != null ? (Collection)this.categories.stream().map(TestCaseCategory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categories(Collection<TestCaseCategory> categories) {
            this.categories = TestCategoryCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(TestCaseCategory ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<TestCaseCategory.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (TestCaseCategory)((TestCaseCategory.Builder)TestCaseCategory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategories(Collection<TestCaseCategory.BuilderImpl> categories) {
            this.categories = TestCategoryCopier.copyFromBuilder(categories);
        }

        public final Map<String, String> getRootGroupConfiguration() {
            if (this.rootGroupConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.rootGroupConfiguration;
        }

        @Override
        public final Builder rootGroupConfiguration(Map<String, String> rootGroupConfiguration) {
            this.rootGroupConfiguration = TestConfigurationCopier.copy(rootGroupConfiguration);
            return this;
        }

        public final void setRootGroupConfiguration(Map<String, String> rootGroupConfiguration) {
            this.rootGroupConfiguration = TestConfigurationCopier.copy(rootGroupConfiguration);
        }

        public final Map<String, String> getGroupConfiguration() {
            if (this.groupConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.groupConfiguration;
        }

        @Override
        public final Builder groupConfiguration(Map<String, String> groupConfiguration) {
            this.groupConfiguration = TestConfigurationCopier.copy(groupConfiguration);
            return this;
        }

        public final void setGroupConfiguration(Map<String, String> groupConfiguration) {
            this.groupConfiguration = TestConfigurationCopier.copy(groupConfiguration);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestCasesResponse build() {
            return new ListTestCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestCasesResponse> {
        public Builder categories(Collection<TestCaseCategory> var1);

        public Builder categories(TestCaseCategory ... var1);

        public Builder categories(Consumer<TestCaseCategory.Builder> ... var1);

        public Builder rootGroupConfiguration(Map<String, String> var1);

        public Builder groupConfiguration(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

