/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneResponse;
import software.amazon.awssdk.services.iotdataplane.model.NamedShadowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNamedShadowsForThingResponse
extends IotDataPlaneResponse
implements ToCopyableBuilder<Builder, ListNamedShadowsForThingResponse> {
    private static final SdkField<List<String>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("results").getter(ListNamedShadowsForThingResponse.getter(ListNamedShadowsForThingResponse::results)).setter(ListNamedShadowsForThingResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNamedShadowsForThingResponse.getter(ListNamedShadowsForThingResponse::nextToken)).setter(ListNamedShadowsForThingResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("timestamp").getter(ListNamedShadowsForThingResponse.getter(ListNamedShadowsForThingResponse::timestamp)).setter(ListNamedShadowsForThingResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, NEXT_TOKEN_FIELD, TIMESTAMP_FIELD));
    private final List<String> results;
    private final String nextToken;
    private final Long timestamp;

    private ListNamedShadowsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
        this.timestamp = builder.timestamp;
    }

    public boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public List<String> results() {
        return this.results;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamedShadowsForThingResponse)) {
            return false;
        }
        ListNamedShadowsForThingResponse other = (ListNamedShadowsForThingResponse)((Object)obj);
        return Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"ListNamedShadowsForThingResponse").add("Results", this.results()).add("NextToken", (Object)this.nextToken()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamedShadowsForThingResponse, T> g) {
        return obj -> g.apply((ListNamedShadowsForThingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDataPlaneResponse.BuilderImpl
    implements Builder {
        private List<String> results = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamedShadowsForThingResponse model) {
            super(model);
            this.results(model.results);
            this.nextToken(model.nextToken);
            this.timestamp(model.timestamp);
        }

        public final Collection<String> getResults() {
            return this.results;
        }

        @Override
        public final Builder results(Collection<String> results) {
            this.results = NamedShadowListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(String ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<String> results) {
            this.results = NamedShadowListCopier.copy(results);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ListNamedShadowsForThingResponse build() {
            return new ListNamedShadowsForThingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDataPlaneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNamedShadowsForThingResponse> {
        public Builder results(Collection<String> var1);

        public Builder results(String ... var1);

        public Builder nextToken(String var1);

        public Builder timestamp(Long var1);
    }
}

