/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatastoreResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<DescribeDatastoreResponse.Builder, DescribeDatastoreResponse> {
    private static final SdkField<Datastore> DATASTORE_FIELD = SdkField.<Datastore> builder(MarshallingType.SDK_POJO)
            .memberName("datastore").getter(getter(DescribeDatastoreResponse::datastore)).setter(setter(Builder::datastore))
            .constructor(Datastore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastore").build()).build();

    private static final SdkField<DatastoreStatistics> STATISTICS_FIELD = SdkField
            .<DatastoreStatistics> builder(MarshallingType.SDK_POJO).memberName("statistics")
            .getter(getter(DescribeDatastoreResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(DatastoreStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_FIELD,
            STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Datastore datastore;

    private final DatastoreStatistics statistics;

    private DescribeDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastore = builder.datastore;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * Information about the data store.
     * </p>
     * 
     * @return Information about the data store.
     */
    public final Datastore datastore() {
        return datastore;
    }

    /**
     * <p>
     * Additional statistical information about the data store. Included if the <code>includeStatistics</code> parameter
     * is set to <code>true</code> in the request.
     * </p>
     * 
     * @return Additional statistical information about the data store. Included if the <code>includeStatistics</code>
     *         parameter is set to <code>true</code> in the request.
     */
    public final DatastoreStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastore());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatastoreResponse)) {
            return false;
        }
        DescribeDatastoreResponse other = (DescribeDatastoreResponse) obj;
        return Objects.equals(datastore(), other.datastore()) && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatastoreResponse").add("Datastore", datastore()).add("Statistics", statistics())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastore":
            return Optional.ofNullable(clazz.cast(datastore()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datastore", DATASTORE_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatastoreResponse, T> g) {
        return obj -> g.apply((DescribeDatastoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatastoreResponse> {
        /**
         * <p>
         * Information about the data store.
         * </p>
         * 
         * @param datastore
         *        Information about the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastore(Datastore datastore);

        /**
         * <p>
         * Information about the data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link Datastore.Builder} avoiding the need to
         * create one manually via {@link Datastore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Datastore.Builder#build()} is called immediately and its result
         * is passed to {@link #datastore(Datastore)}.
         * 
         * @param datastore
         *        a consumer that will call methods on {@link Datastore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastore(Datastore)
         */
        default Builder datastore(Consumer<Datastore.Builder> datastore) {
            return datastore(Datastore.builder().applyMutation(datastore).build());
        }

        /**
         * <p>
         * Additional statistical information about the data store. Included if the <code>includeStatistics</code>
         * parameter is set to <code>true</code> in the request.
         * </p>
         * 
         * @param statistics
         *        Additional statistical information about the data store. Included if the
         *        <code>includeStatistics</code> parameter is set to <code>true</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(DatastoreStatistics statistics);

        /**
         * <p>
         * Additional statistical information about the data store. Included if the <code>includeStatistics</code>
         * parameter is set to <code>true</code> in the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatastoreStatistics.Builder} avoiding the
         * need to create one manually via {@link DatastoreStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(DatastoreStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link DatastoreStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(DatastoreStatistics)
         */
        default Builder statistics(Consumer<DatastoreStatistics.Builder> statistics) {
            return statistics(DatastoreStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private Datastore datastore;

        private DatastoreStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatastoreResponse model) {
            super(model);
            datastore(model.datastore);
            statistics(model.statistics);
        }

        public final Datastore.Builder getDatastore() {
            return datastore != null ? datastore.toBuilder() : null;
        }

        public final void setDatastore(Datastore.BuilderImpl datastore) {
            this.datastore = datastore != null ? datastore.build() : null;
        }

        @Override
        public final Builder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public final DatastoreStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(DatastoreStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(DatastoreStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public DescribeDatastoreResponse build() {
            return new DescribeDatastoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
