/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics information about the channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelStatistics.Builder, ChannelStatistics> {
    private static final SdkField<EstimatedResourceSize> SIZE_FIELD = SdkField
            .<EstimatedResourceSize> builder(MarshallingType.SDK_POJO).memberName("size").getter(getter(ChannelStatistics::size))
            .setter(setter(Builder::size)).constructor(EstimatedResourceSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EstimatedResourceSize size;

    private ChannelStatistics(BuilderImpl builder) {
        this.size = builder.size;
    }

    /**
     * <p>
     * The estimated size of the channel.
     * </p>
     * 
     * @return The estimated size of the channel.
     */
    public final EstimatedResourceSize size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelStatistics)) {
            return false;
        }
        ChannelStatistics other = (ChannelStatistics) obj;
        return Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelStatistics").add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("size", SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelStatistics, T> g) {
        return obj -> g.apply((ChannelStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelStatistics> {
        /**
         * <p>
         * The estimated size of the channel.
         * </p>
         * 
         * @param size
         *        The estimated size of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(EstimatedResourceSize size);

        /**
         * <p>
         * The estimated size of the channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link EstimatedResourceSize.Builder} avoiding
         * the need to create one manually via {@link EstimatedResourceSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EstimatedResourceSize.Builder#build()} is called immediately and
         * its result is passed to {@link #size(EstimatedResourceSize)}.
         * 
         * @param size
         *        a consumer that will call methods on {@link EstimatedResourceSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #size(EstimatedResourceSize)
         */
        default Builder size(Consumer<EstimatedResourceSize.Builder> size) {
            return size(EstimatedResourceSize.builder().applyMutation(size).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EstimatedResourceSize size;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelStatistics model) {
            size(model.size);
        }

        public final EstimatedResourceSize.Builder getSize() {
            return size != null ? size.toBuilder() : null;
        }

        public final void setSize(EstimatedResourceSize.BuilderImpl size) {
            this.size = size != null ? size.build() : null;
        }

        @Override
        public final Builder size(EstimatedResourceSize size) {
            this.size = size;
            return this;
        }

        @Override
        public ChannelStatistics build() {
            return new ChannelStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
