/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetContentsRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, ListDatasetContentsRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetName").getter(ListDatasetContentsRequest.getter(ListDatasetContentsRequest::datasetName)).setter(ListDatasetContentsRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDatasetContentsRequest.getter(ListDatasetContentsRequest::nextToken)).setter(ListDatasetContentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDatasetContentsRequest.getter(ListDatasetContentsRequest::maxResults)).setter(ListDatasetContentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Instant> SCHEDULED_ON_OR_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("scheduledOnOrAfter").getter(ListDatasetContentsRequest.getter(ListDatasetContentsRequest::scheduledOnOrAfter)).setter(ListDatasetContentsRequest.setter(Builder::scheduledOnOrAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scheduledOnOrAfter").build()}).build();
    private static final SdkField<Instant> SCHEDULED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("scheduledBefore").getter(ListDatasetContentsRequest.getter(ListDatasetContentsRequest::scheduledBefore)).setter(ListDatasetContentsRequest.setter(Builder::scheduledBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scheduledBefore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SCHEDULED_ON_OR_AFTER_FIELD, SCHEDULED_BEFORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datasetName", DATASET_NAME_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("scheduledOnOrAfter", SCHEDULED_ON_OR_AFTER_FIELD);
            this.put("scheduledBefore", SCHEDULED_BEFORE_FIELD);
        }
    });
    private final String datasetName;
    private final String nextToken;
    private final Integer maxResults;
    private final Instant scheduledOnOrAfter;
    private final Instant scheduledBefore;

    private ListDatasetContentsRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.scheduledOnOrAfter = builder.scheduledOnOrAfter;
        this.scheduledBefore = builder.scheduledBefore;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant scheduledOnOrAfter() {
        return this.scheduledOnOrAfter;
    }

    public final Instant scheduledBefore() {
        return this.scheduledBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledOnOrAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledBefore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetContentsRequest)) {
            return false;
        }
        ListDatasetContentsRequest other = (ListDatasetContentsRequest)((Object)obj);
        return Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.scheduledOnOrAfter(), other.scheduledOnOrAfter()) && Objects.equals(this.scheduledBefore(), other.scheduledBefore());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetContentsRequest").add("DatasetName", (Object)this.datasetName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ScheduledOnOrAfter", (Object)this.scheduledOnOrAfter()).add("ScheduledBefore", (Object)this.scheduledBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "scheduledOnOrAfter": {
                return Optional.ofNullable(clazz.cast(this.scheduledOnOrAfter()));
            }
            case "scheduledBefore": {
                return Optional.ofNullable(clazz.cast(this.scheduledBefore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetContentsRequest, T> g) {
        return obj -> g.apply((ListDatasetContentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String datasetName;
        private String nextToken;
        private Integer maxResults;
        private Instant scheduledOnOrAfter;
        private Instant scheduledBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetContentsRequest model) {
            super(model);
            this.datasetName(model.datasetName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.scheduledOnOrAfter(model.scheduledOnOrAfter);
            this.scheduledBefore(model.scheduledBefore);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getScheduledOnOrAfter() {
            return this.scheduledOnOrAfter;
        }

        public final void setScheduledOnOrAfter(Instant scheduledOnOrAfter) {
            this.scheduledOnOrAfter = scheduledOnOrAfter;
        }

        @Override
        public final Builder scheduledOnOrAfter(Instant scheduledOnOrAfter) {
            this.scheduledOnOrAfter = scheduledOnOrAfter;
            return this;
        }

        public final Instant getScheduledBefore() {
            return this.scheduledBefore;
        }

        public final void setScheduledBefore(Instant scheduledBefore) {
            this.scheduledBefore = scheduledBefore;
        }

        @Override
        public final Builder scheduledBefore(Instant scheduledBefore) {
            this.scheduledBefore = scheduledBefore;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatasetContentsRequest build() {
            return new ListDatasetContentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetContentsRequest> {
        public Builder datasetName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder scheduledOnOrAfter(Instant var1);

        public Builder scheduledBefore(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

