/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3Storage;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorage;
import software.amazon.awssdk.services.iotanalytics.model.ServiceManagedDatastoreS3Storage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreStorage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreStorage> {
    private static final SdkField<ServiceManagedDatastoreS3Storage> SERVICE_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceManagedS3").getter(DatastoreStorage.getter(DatastoreStorage::serviceManagedS3)).setter(DatastoreStorage.setter(Builder::serviceManagedS3)).constructor(ServiceManagedDatastoreS3Storage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()}).build();
    private static final SdkField<CustomerManagedDatastoreS3Storage> CUSTOMER_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerManagedS3").getter(DatastoreStorage.getter(DatastoreStorage::customerManagedS3)).setter(DatastoreStorage.setter(Builder::customerManagedS3)).constructor(CustomerManagedDatastoreS3Storage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()}).build();
    private static final SdkField<DatastoreIotSiteWiseMultiLayerStorage> IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotSiteWiseMultiLayerStorage").getter(DatastoreStorage.getter(DatastoreStorage::iotSiteWiseMultiLayerStorage)).setter(DatastoreStorage.setter(Builder::iotSiteWiseMultiLayerStorage)).constructor(DatastoreIotSiteWiseMultiLayerStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseMultiLayerStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD, CUSTOMER_MANAGED_S3_FIELD, IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ServiceManagedDatastoreS3Storage serviceManagedS3;
    private final CustomerManagedDatastoreS3Storage customerManagedS3;
    private final DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage;
    private final Type type;

    private DatastoreStorage(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
        this.iotSiteWiseMultiLayerStorage = builder.iotSiteWiseMultiLayerStorage;
        this.type = builder.type;
    }

    public final ServiceManagedDatastoreS3Storage serviceManagedS3() {
        return this.serviceManagedS3;
    }

    public final CustomerManagedDatastoreS3Storage customerManagedS3() {
        return this.customerManagedS3;
    }

    public final DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage() {
        return this.iotSiteWiseMultiLayerStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotSiteWiseMultiLayerStorage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorage)) {
            return false;
        }
        DatastoreStorage other = (DatastoreStorage)obj;
        return Objects.equals(this.serviceManagedS3(), other.serviceManagedS3()) && Objects.equals(this.customerManagedS3(), other.customerManagedS3()) && Objects.equals(this.iotSiteWiseMultiLayerStorage(), other.iotSiteWiseMultiLayerStorage());
    }

    public final String toString() {
        return ToString.builder((String)"DatastoreStorage").add("ServiceManagedS3", (Object)this.serviceManagedS3()).add("CustomerManagedS3", (Object)this.customerManagedS3()).add("IotSiteWiseMultiLayerStorage", (Object)this.iotSiteWiseMultiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceManagedS3": {
                return Optional.ofNullable(clazz.cast(this.serviceManagedS3()));
            }
            case "customerManagedS3": {
                return Optional.ofNullable(clazz.cast(this.customerManagedS3()));
            }
            case "iotSiteWiseMultiLayerStorage": {
                return Optional.ofNullable(clazz.cast(this.iotSiteWiseMultiLayerStorage()));
            }
        }
        return Optional.empty();
    }

    public static DatastoreStorage fromServiceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3) {
        return (DatastoreStorage)DatastoreStorage.builder().serviceManagedS3(serviceManagedS3).build();
    }

    public static DatastoreStorage fromServiceManagedS3(Consumer<ServiceManagedDatastoreS3Storage.Builder> serviceManagedS3) {
        ServiceManagedDatastoreS3Storage.Builder builder = ServiceManagedDatastoreS3Storage.builder();
        serviceManagedS3.accept(builder);
        return DatastoreStorage.fromServiceManagedS3((ServiceManagedDatastoreS3Storage)builder.build());
    }

    public static DatastoreStorage fromCustomerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3) {
        return (DatastoreStorage)DatastoreStorage.builder().customerManagedS3(customerManagedS3).build();
    }

    public static DatastoreStorage fromCustomerManagedS3(Consumer<CustomerManagedDatastoreS3Storage.Builder> customerManagedS3) {
        CustomerManagedDatastoreS3Storage.Builder builder = CustomerManagedDatastoreS3Storage.builder();
        customerManagedS3.accept(builder);
        return DatastoreStorage.fromCustomerManagedS3((CustomerManagedDatastoreS3Storage)builder.build());
    }

    public static DatastoreStorage fromIotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage) {
        return (DatastoreStorage)DatastoreStorage.builder().iotSiteWiseMultiLayerStorage(iotSiteWiseMultiLayerStorage).build();
    }

    public static DatastoreStorage fromIotSiteWiseMultiLayerStorage(Consumer<DatastoreIotSiteWiseMultiLayerStorage.Builder> iotSiteWiseMultiLayerStorage) {
        DatastoreIotSiteWiseMultiLayerStorage.Builder builder = DatastoreIotSiteWiseMultiLayerStorage.builder();
        iotSiteWiseMultiLayerStorage.accept(builder);
        return DatastoreStorage.fromIotSiteWiseMultiLayerStorage((DatastoreIotSiteWiseMultiLayerStorage)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorage, T> g) {
        return obj -> g.apply((DatastoreStorage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SERVICE_MANAGED_S3,
        CUSTOMER_MANAGED_S3,
        IOT_SITE_WISE_MULTI_LAYER_STORAGE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ServiceManagedDatastoreS3Storage serviceManagedS3;
        private CustomerManagedDatastoreS3Storage customerManagedS3;
        private DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorage model) {
            this.serviceManagedS3(model.serviceManagedS3);
            this.customerManagedS3(model.customerManagedS3);
            this.iotSiteWiseMultiLayerStorage(model.iotSiteWiseMultiLayerStorage);
        }

        public final ServiceManagedDatastoreS3Storage.Builder getServiceManagedS3() {
            return this.serviceManagedS3 != null ? this.serviceManagedS3.toBuilder() : null;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3Storage.BuilderImpl serviceManagedS3) {
            ServiceManagedDatastoreS3Storage oldValue = this.serviceManagedS3;
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
            this.handleUnionValueChange(Type.SERVICE_MANAGED_S3, oldValue, this.serviceManagedS3);
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3) {
            ServiceManagedDatastoreS3Storage oldValue = this.serviceManagedS3;
            this.serviceManagedS3 = serviceManagedS3;
            this.handleUnionValueChange(Type.SERVICE_MANAGED_S3, oldValue, this.serviceManagedS3);
            return this;
        }

        public final CustomerManagedDatastoreS3Storage.Builder getCustomerManagedS3() {
            return this.customerManagedS3 != null ? this.customerManagedS3.toBuilder() : null;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3Storage.BuilderImpl customerManagedS3) {
            CustomerManagedDatastoreS3Storage oldValue = this.customerManagedS3;
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
            this.handleUnionValueChange(Type.CUSTOMER_MANAGED_S3, oldValue, this.customerManagedS3);
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3) {
            CustomerManagedDatastoreS3Storage oldValue = this.customerManagedS3;
            this.customerManagedS3 = customerManagedS3;
            this.handleUnionValueChange(Type.CUSTOMER_MANAGED_S3, oldValue, this.customerManagedS3);
            return this;
        }

        public final DatastoreIotSiteWiseMultiLayerStorage.Builder getIotSiteWiseMultiLayerStorage() {
            return this.iotSiteWiseMultiLayerStorage != null ? this.iotSiteWiseMultiLayerStorage.toBuilder() : null;
        }

        public final void setIotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage.BuilderImpl iotSiteWiseMultiLayerStorage) {
            DatastoreIotSiteWiseMultiLayerStorage oldValue = this.iotSiteWiseMultiLayerStorage;
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.build() : null;
            this.handleUnionValueChange(Type.IOT_SITE_WISE_MULTI_LAYER_STORAGE, oldValue, this.iotSiteWiseMultiLayerStorage);
        }

        @Override
        public final Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage) {
            DatastoreIotSiteWiseMultiLayerStorage oldValue = this.iotSiteWiseMultiLayerStorage;
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
            this.handleUnionValueChange(Type.IOT_SITE_WISE_MULTI_LAYER_STORAGE, oldValue, this.iotSiteWiseMultiLayerStorage);
            return this;
        }

        public DatastoreStorage build() {
            return new DatastoreStorage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreStorage> {
        public Builder serviceManagedS3(ServiceManagedDatastoreS3Storage var1);

        default public Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3Storage.Builder> serviceManagedS3) {
            return this.serviceManagedS3((ServiceManagedDatastoreS3Storage)((ServiceManagedDatastoreS3Storage.Builder)ServiceManagedDatastoreS3Storage.builder().applyMutation(serviceManagedS3)).build());
        }

        public Builder customerManagedS3(CustomerManagedDatastoreS3Storage var1);

        default public Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3Storage.Builder> customerManagedS3) {
            return this.customerManagedS3((CustomerManagedDatastoreS3Storage)((CustomerManagedDatastoreS3Storage.Builder)CustomerManagedDatastoreS3Storage.builder().applyMutation(customerManagedS3)).build());
        }

        public Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage var1);

        default public Builder iotSiteWiseMultiLayerStorage(Consumer<DatastoreIotSiteWiseMultiLayerStorage.Builder> iotSiteWiseMultiLayerStorage) {
            return this.iotSiteWiseMultiLayerStorage((DatastoreIotSiteWiseMultiLayerStorage)((DatastoreIotSiteWiseMultiLayerStorage.Builder)DatastoreIotSiteWiseMultiLayerStorage.builder().applyMutation(iotSiteWiseMultiLayerStorage)).build());
        }
    }
}

