/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivitiesCopier;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivity;
import software.amazon.awssdk.services.iotanalytics.model.Tag;
import software.amazon.awssdk.services.iotanalytics.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePipelineRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, CreatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineName)).setter(CreatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<List<PipelineActivity>> PIPELINE_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineActivities").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineActivities)).setter(CreatePipelineRequest.setter(Builder::pipelineActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreatePipelineRequest.getter(CreatePipelineRequest::tags)).setter(CreatePipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_ACTIVITIES_FIELD, TAGS_FIELD));
    private final String pipelineName;
    private final List<PipelineActivity> pipelineActivities;
    private final List<Tag> tags;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineActivities = builder.pipelineActivities;
        this.tags = builder.tags;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final boolean hasPipelineActivities() {
        return this.pipelineActivities != null && !(this.pipelineActivities instanceof SdkAutoConstructList);
    }

    public final List<PipelineActivity> pipelineActivities() {
        return this.pipelineActivities;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineActivities() ? this.pipelineActivities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && this.hasPipelineActivities() == other.hasPipelineActivities() && Objects.equals(this.pipelineActivities(), other.pipelineActivities()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineActivities", this.hasPipelineActivities() ? this.pipelineActivities() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineActivities": {
                return Optional.ofNullable(clazz.cast(this.pipelineActivities()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private List<PipelineActivity> pipelineActivities = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineActivities(model.pipelineActivities);
            this.tags(model.tags);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final List<PipelineActivity.Builder> getPipelineActivities() {
            List<PipelineActivity.Builder> result = PipelineActivitiesCopier.copyToBuilder(this.pipelineActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pipelineActivities(Collection<PipelineActivity> pipelineActivities) {
            this.pipelineActivities = PipelineActivitiesCopier.copy(pipelineActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineActivities(PipelineActivity ... pipelineActivities) {
            this.pipelineActivities(Arrays.asList(pipelineActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineActivities(Consumer<PipelineActivity.Builder> ... pipelineActivities) {
            this.pipelineActivities(Stream.of(pipelineActivities).map(c -> (PipelineActivity)((PipelineActivity.Builder)PipelineActivity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineActivities(Collection<PipelineActivity.BuilderImpl> pipelineActivities) {
            this.pipelineActivities = PipelineActivitiesCopier.copyFromBuilder(pipelineActivities);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineActivities(Collection<PipelineActivity> var1);

        public Builder pipelineActivities(PipelineActivity ... var1);

        public Builder pipelineActivities(Consumer<PipelineActivity.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

