/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatastoreRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<CreateDatastoreRequest.Builder, CreateDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreName").getter(getter(CreateDatastoreRequest::datastoreName))
            .setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()).build();

    private static final SdkField<DatastoreStorage> DATASTORE_STORAGE_FIELD = SdkField
            .<DatastoreStorage> builder(MarshallingType.SDK_POJO).memberName("datastoreStorage")
            .getter(getter(CreateDatastoreRequest::datastoreStorage)).setter(setter(Builder::datastoreStorage))
            .constructor(DatastoreStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStorage").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("retentionPeriod")
            .getter(getter(CreateDatastoreRequest::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDatastoreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FileFormatConfiguration> FILE_FORMAT_CONFIGURATION_FIELD = SdkField
            .<FileFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("fileFormatConfiguration")
            .getter(getter(CreateDatastoreRequest::fileFormatConfiguration)).setter(setter(Builder::fileFormatConfiguration))
            .constructor(FileFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormatConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            DATASTORE_STORAGE_FIELD, RETENTION_PERIOD_FIELD, TAGS_FIELD, FILE_FORMAT_CONFIGURATION_FIELD));

    private final String datastoreName;

    private final DatastoreStorage datastoreStorage;

    private final RetentionPeriod retentionPeriod;

    private final List<Tag> tags;

    private final FileFormatConfiguration fileFormatConfiguration;

    private CreateDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.datastoreStorage = builder.datastoreStorage;
        this.retentionPeriod = builder.retentionPeriod;
        this.tags = builder.tags;
        this.fileFormatConfiguration = builder.fileFormatConfiguration;
    }

    /**
     * <p>
     * The name of the data store.
     * </p>
     * 
     * @return The name of the data store.
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * Where data store data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
     * cannot change this storage option after the data store is created.
     * </p>
     * 
     * @return Where data store data is stored. You can choose one of <code>serviceManagedS3</code> or
     *         <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>.
     *         You cannot change this storage option after the data store is created.
     */
    public final DatastoreStorage datastoreStorage() {
        return datastoreStorage;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is
     * selected, this parameter is ignored.
     * </p>
     * 
     * @return How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage
     *         is selected, this parameter is ignored.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata which can be used to manage the data store.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a
     * href="https://parquet.apache.org/">Parquet</a>.
     * </p>
     * <p>
     * The default file format is JSON. You can specify only one format.
     * </p>
     * <p>
     * You can't change the file format after you create the data store.
     * </p>
     * 
     * @return Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a
     *         href="https://parquet.apache.org/">Parquet</a>.</p>
     *         <p>
     *         The default file format is JSON. You can specify only one format.
     *         </p>
     *         <p>
     *         You can't change the file format after you create the data store.
     */
    public final FileFormatConfiguration fileFormatConfiguration() {
        return fileFormatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStorage());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatastoreRequest)) {
            return false;
        }
        CreateDatastoreRequest other = (CreateDatastoreRequest) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreStorage(), other.datastoreStorage())
                && Objects.equals(retentionPeriod(), other.retentionPeriod()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(fileFormatConfiguration(), other.fileFormatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatastoreRequest").add("DatastoreName", datastoreName())
                .add("DatastoreStorage", datastoreStorage()).add("RetentionPeriod", retentionPeriod())
                .add("Tags", hasTags() ? tags() : null).add("FileFormatConfiguration", fileFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "datastoreStorage":
            return Optional.ofNullable(clazz.cast(datastoreStorage()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "fileFormatConfiguration":
            return Optional.ofNullable(clazz.cast(fileFormatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatastoreRequest, T> g) {
        return obj -> g.apply((CreateDatastoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatastoreRequest> {
        /**
         * <p>
         * The name of the data store.
         * </p>
         * 
         * @param datastoreName
         *        The name of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * Where data store data is stored. You can choose one of <code>serviceManagedS3</code> or
         * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
         * cannot change this storage option after the data store is created.
         * </p>
         * 
         * @param datastoreStorage
         *        Where data store data is stored. You can choose one of <code>serviceManagedS3</code> or
         *        <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>
         *        . You cannot change this storage option after the data store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreStorage(DatastoreStorage datastoreStorage);

        /**
         * <p>
         * Where data store data is stored. You can choose one of <code>serviceManagedS3</code> or
         * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
         * cannot change this storage option after the data store is created.
         * </p>
         * This is a convenience that creates an instance of the {@link DatastoreStorage.Builder} avoiding the need to
         * create one manually via {@link DatastoreStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatastoreStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #datastoreStorage(DatastoreStorage)}.
         * 
         * @param datastoreStorage
         *        a consumer that will call methods on {@link DatastoreStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastoreStorage(DatastoreStorage)
         */
        default Builder datastoreStorage(Consumer<DatastoreStorage.Builder> datastoreStorage) {
            return datastoreStorage(DatastoreStorage.builder().applyMutation(datastoreStorage).build());
        }

        /**
         * <p>
         * How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is
         * selected, this parameter is ignored.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the data store. When <code>customerManagedS3</code>
         *        storage is selected, this parameter is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is
         * selected, this parameter is ignored.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the data store.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the data store.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the data store.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a
         * href="https://parquet.apache.org/">Parquet</a>.
         * </p>
         * <p>
         * The default file format is JSON. You can specify only one format.
         * </p>
         * <p>
         * You can't change the file format after you create the data store.
         * </p>
         * 
         * @param fileFormatConfiguration
         *        Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and
         *        <a href="https://parquet.apache.org/">Parquet</a>.</p>
         *        <p>
         *        The default file format is JSON. You can specify only one format.
         *        </p>
         *        <p>
         *        You can't change the file format after you create the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormatConfiguration(FileFormatConfiguration fileFormatConfiguration);

        /**
         * <p>
         * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a
         * href="https://parquet.apache.org/">Parquet</a>.
         * </p>
         * <p>
         * The default file format is JSON. You can specify only one format.
         * </p>
         * <p>
         * You can't change the file format after you create the data store.
         * </p>
         * This is a convenience that creates an instance of the {@link FileFormatConfiguration.Builder} avoiding the
         * need to create one manually via {@link FileFormatConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #fileFormatConfiguration(FileFormatConfiguration)}.
         * 
         * @param fileFormatConfiguration
         *        a consumer that will call methods on {@link FileFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileFormatConfiguration(FileFormatConfiguration)
         */
        default Builder fileFormatConfiguration(Consumer<FileFormatConfiguration.Builder> fileFormatConfiguration) {
            return fileFormatConfiguration(FileFormatConfiguration.builder().applyMutation(fileFormatConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String datastoreName;

        private DatastoreStorage datastoreStorage;

        private RetentionPeriod retentionPeriod;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private FileFormatConfiguration fileFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatastoreRequest model) {
            super(model);
            datastoreName(model.datastoreName);
            datastoreStorage(model.datastoreStorage);
            retentionPeriod(model.retentionPeriod);
            tags(model.tags);
            fileFormatConfiguration(model.fileFormatConfiguration);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final DatastoreStorage.Builder getDatastoreStorage() {
            return datastoreStorage != null ? datastoreStorage.toBuilder() : null;
        }

        @Override
        public final Builder datastoreStorage(DatastoreStorage datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        public final void setDatastoreStorage(DatastoreStorage.BuilderImpl datastoreStorage) {
            this.datastoreStorage = datastoreStorage != null ? datastoreStorage.build() : null;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final FileFormatConfiguration.Builder getFileFormatConfiguration() {
            return fileFormatConfiguration != null ? fileFormatConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder fileFormatConfiguration(FileFormatConfiguration fileFormatConfiguration) {
            this.fileFormatConfiguration = fileFormatConfiguration;
            return this;
        }

        public final void setFileFormatConfiguration(FileFormatConfiguration.BuilderImpl fileFormatConfiguration) {
            this.fileFormatConfiguration = fileFormatConfiguration != null ? fileFormatConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatastoreRequest build() {
            return new CreateDatastoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
