/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.ChannelSummariesCopier;
import software.amazon.awssdk.services.iotanalytics.model.ChannelSummary;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, ListChannelsResponse> {
    private static final SdkField<List<ChannelSummary>> CHANNEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListChannelsResponse.getter(ListChannelsResponse::channelSummaries)).setter(ListChannelsResponse.setter(Builder::channelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListChannelsResponse.getter(ListChannelsResponse::nextToken)).setter(ListChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ChannelSummary> channelSummaries;
    private final String nextToken;

    private ListChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channelSummaries = builder.channelSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasChannelSummaries() {
        return this.channelSummaries != null && !(this.channelSummaries instanceof SdkAutoConstructList);
    }

    public List<ChannelSummary> channelSummaries() {
        return this.channelSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsResponse)) {
            return false;
        }
        ListChannelsResponse other = (ListChannelsResponse)((Object)obj);
        return Objects.equals(this.channelSummaries(), other.channelSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListChannelsResponse").add("ChannelSummaries", this.channelSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelSummaries": {
                return Optional.ofNullable(clazz.cast(this.channelSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsResponse, T> g) {
        return obj -> g.apply((ListChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<ChannelSummary> channelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsResponse model) {
            super(model);
            this.channelSummaries(model.channelSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ChannelSummary.Builder> getChannelSummaries() {
            return this.channelSummaries != null ? (Collection)this.channelSummaries.stream().map(ChannelSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channelSummaries(Collection<ChannelSummary> channelSummaries) {
            this.channelSummaries = ChannelSummariesCopier.copy(channelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelSummaries(ChannelSummary ... channelSummaries) {
            this.channelSummaries(Arrays.asList(channelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelSummaries(Consumer<ChannelSummary.Builder> ... channelSummaries) {
            this.channelSummaries(Stream.of(channelSummaries).map(c -> (ChannelSummary)((ChannelSummary.Builder)ChannelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChannelSummaries(Collection<ChannelSummary.BuilderImpl> channelSummaries) {
            this.channelSummaries = ChannelSummariesCopier.copyFromBuilder(channelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChannelsResponse build() {
            return new ListChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelsResponse> {
        public Builder channelSummaries(Collection<ChannelSummary> var1);

        public Builder channelSummaries(ChannelSummary ... var1);

        public Builder channelSummaries(Consumer<ChannelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

