/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about pipeline reprocessing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReprocessingSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReprocessingSummary.Builder, ReprocessingSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReprocessingSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReprocessingSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReprocessingSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private final Instant creationTime;

    private ReprocessingSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The 'reprocessingId' returned by "StartPipelineReprocessing".
     * </p>
     * 
     * @return The 'reprocessingId' returned by "StartPipelineReprocessing".
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The status of the pipeline reprocessing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReprocessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the pipeline reprocessing.
     * @see ReprocessingStatus
     */
    public ReprocessingStatus status() {
        return ReprocessingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the pipeline reprocessing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReprocessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the pipeline reprocessing.
     * @see ReprocessingStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the pipeline reprocessing was created.
     * </p>
     * 
     * @return The time the pipeline reprocessing was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReprocessingSummary)) {
            return false;
        }
        ReprocessingSummary other = (ReprocessingSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReprocessingSummary").add("Id", id()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReprocessingSummary, T> g) {
        return obj -> g.apply((ReprocessingSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReprocessingSummary> {
        /**
         * <p>
         * The 'reprocessingId' returned by "StartPipelineReprocessing".
         * </p>
         * 
         * @param id
         *        The 'reprocessingId' returned by "StartPipelineReprocessing".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the pipeline reprocessing.
         * </p>
         * 
         * @param status
         *        The status of the pipeline reprocessing.
         * @see ReprocessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReprocessingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the pipeline reprocessing.
         * </p>
         * 
         * @param status
         *        The status of the pipeline reprocessing.
         * @see ReprocessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReprocessingStatus
         */
        Builder status(ReprocessingStatus status);

        /**
         * <p>
         * The time the pipeline reprocessing was created.
         * </p>
         * 
         * @param creationTime
         *        The time the pipeline reprocessing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReprocessingSummary model) {
            id(model.id);
            status(model.status);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReprocessingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public ReprocessingSummary build() {
            return new ReprocessingSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
