/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of the variable as a structure that specifies an output file URI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputFileUriValue implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputFileUriValue.Builder, OutputFileUriValue> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OutputFileUriValue::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileName;

    private OutputFileUriValue(BuilderImpl builder) {
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The URI of the location where data set contents are stored, usually the URI of a file in an S3 bucket.
     * </p>
     * 
     * @return The URI of the location where data set contents are stored, usually the URI of a file in an S3 bucket.
     */
    public String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFileUriValue)) {
            return false;
        }
        OutputFileUriValue other = (OutputFileUriValue) obj;
        return Objects.equals(fileName(), other.fileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputFileUriValue").add("FileName", fileName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputFileUriValue, T> g) {
        return obj -> g.apply((OutputFileUriValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputFileUriValue> {
        /**
         * <p>
         * The URI of the location where data set contents are stored, usually the URI of a file in an S3 bucket.
         * </p>
         * 
         * @param fileName
         *        The URI of the location where data set contents are stored, usually the URI of a file in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);
    }

    static final class BuilderImpl implements Builder {
        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFileUriValue model) {
            fileName(model.fileName);
        }

        public final String getFileName() {
            return fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public OutputFileUriValue build() {
            return new OutputFileUriValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
