/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that computes an arithmetic expression using the message's attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MathActivity implements SdkPojo, Serializable, ToCopyableBuilder<MathActivity.Builder, MathActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MathActivity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MathActivity::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> MATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MathActivity::math)).setter(setter(Builder::math))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("math").build()).build();

    private static final SdkField<String> NEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MathActivity::next)).setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTE_FIELD,
            MATH_FIELD, NEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String attribute;

    private final String math;

    private final String next;

    private MathActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.attribute = builder.attribute;
        this.math = builder.math;
        this.next = builder.next;
    }

    /**
     * <p>
     * The name of the 'math' activity.
     * </p>
     * 
     * @return The name of the 'math' activity.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the attribute that contains the result of the math operation.
     * </p>
     * 
     * @return The name of the attribute that contains the result of the math operation.
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * An expression that uses one or more existing attributes and must return an integer value.
     * </p>
     * 
     * @return An expression that uses one or more existing attributes and must return an integer value.
     */
    public String math() {
        return math;
    }

    /**
     * <p>
     * The next activity in the pipeline.
     * </p>
     * 
     * @return The next activity in the pipeline.
     */
    public String next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(math());
        hashCode = 31 * hashCode + Objects.hashCode(next());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MathActivity)) {
            return false;
        }
        MathActivity other = (MathActivity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(attribute(), other.attribute())
                && Objects.equals(math(), other.math()) && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MathActivity").add("Name", name()).add("Attribute", attribute()).add("Math", math())
                .add("Next", next()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "math":
            return Optional.ofNullable(clazz.cast(math()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MathActivity, T> g) {
        return obj -> g.apply((MathActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MathActivity> {
        /**
         * <p>
         * The name of the 'math' activity.
         * </p>
         * 
         * @param name
         *        The name of the 'math' activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute that contains the result of the math operation.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute that contains the result of the math operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * An expression that uses one or more existing attributes and must return an integer value.
         * </p>
         * 
         * @param math
         *        An expression that uses one or more existing attributes and must return an integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder math(String math);

        /**
         * <p>
         * The next activity in the pipeline.
         * </p>
         * 
         * @param next
         *        The next activity in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String next);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String attribute;

        private String math;

        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(MathActivity model) {
            name(model.name);
            attribute(model.attribute);
            math(model.math);
            next(model.next);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getMath() {
            return math;
        }

        @Override
        public final Builder math(String math) {
            this.math = math;
            return this;
        }

        public final void setMath(String math) {
            this.math = math;
        }

        public final String getNext() {
            return next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public MathActivity build() {
            return new MathActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
