/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetContentsRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<ListDatasetContentsRequest.Builder, ListDatasetContentsRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDatasetContentsRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDatasetContentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDatasetContentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<Instant> SCHEDULED_ON_OR_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListDatasetContentsRequest::scheduledOnOrAfter)).setter(setter(Builder::scheduledOnOrAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scheduledOnOrAfter").build())
            .build();

    private static final SdkField<Instant> SCHEDULED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListDatasetContentsRequest::scheduledBefore)).setter(setter(Builder::scheduledBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scheduledBefore").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SCHEDULED_ON_OR_AFTER_FIELD, SCHEDULED_BEFORE_FIELD));

    private final String datasetName;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant scheduledOnOrAfter;

    private final Instant scheduledBefore;

    private ListDatasetContentsRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.scheduledOnOrAfter = builder.scheduledOnOrAfter;
        this.scheduledBefore = builder.scheduledBefore;
    }

    /**
     * <p>
     * The name of the data set whose contents information you want to list.
     * </p>
     * 
     * @return The name of the data set whose contents information you want to list.
     */
    public String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     * 
     * @return The maximum number of results to return in this request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter to limit results to those data set contents whose creation is scheduled on or after the given time. See
     * the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
     * </p>
     * 
     * @return A filter to limit results to those data set contents whose creation is scheduled on or after the given
     *         time. See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
     */
    public Instant scheduledOnOrAfter() {
        return scheduledOnOrAfter;
    }

    /**
     * <p>
     * A filter to limit results to those data set contents whose creation is scheduled before the given time. See the
     * field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
     * </p>
     * 
     * @return A filter to limit results to those data set contents whose creation is scheduled before the given time.
     *         See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
     */
    public Instant scheduledBefore() {
        return scheduledBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledOnOrAfter());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledBefore());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetContentsRequest)) {
            return false;
        }
        ListDatasetContentsRequest other = (ListDatasetContentsRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(scheduledOnOrAfter(), other.scheduledOnOrAfter())
                && Objects.equals(scheduledBefore(), other.scheduledBefore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDatasetContentsRequest").add("DatasetName", datasetName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("ScheduledOnOrAfter", scheduledOnOrAfter())
                .add("ScheduledBefore", scheduledBefore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "scheduledOnOrAfter":
            return Optional.ofNullable(clazz.cast(scheduledOnOrAfter()));
        case "scheduledBefore":
            return Optional.ofNullable(clazz.cast(scheduledBefore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetContentsRequest, T> g) {
        return obj -> g.apply((ListDatasetContentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasetContentsRequest> {
        /**
         * <p>
         * The name of the data set whose contents information you want to list.
         * </p>
         * 
         * @param datasetName
         *        The name of the data set whose contents information you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in this request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter to limit results to those data set contents whose creation is scheduled on or after the given time.
         * See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
         * </p>
         * 
         * @param scheduledOnOrAfter
         *        A filter to limit results to those data set contents whose creation is scheduled on or after the given
         *        time. See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledOnOrAfter(Instant scheduledOnOrAfter);

        /**
         * <p>
         * A filter to limit results to those data set contents whose creation is scheduled before the given time. See
         * the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
         * </p>
         * 
         * @param scheduledBefore
         *        A filter to limit results to those data set contents whose creation is scheduled before the given
         *        time. See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledBefore(Instant scheduledBefore);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String datasetName;

        private String nextToken;

        private Integer maxResults;

        private Instant scheduledOnOrAfter;

        private Instant scheduledBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetContentsRequest model) {
            super(model);
            datasetName(model.datasetName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            scheduledOnOrAfter(model.scheduledOnOrAfter);
            scheduledBefore(model.scheduledBefore);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Instant getScheduledOnOrAfter() {
            return scheduledOnOrAfter;
        }

        @Override
        public final Builder scheduledOnOrAfter(Instant scheduledOnOrAfter) {
            this.scheduledOnOrAfter = scheduledOnOrAfter;
            return this;
        }

        public final void setScheduledOnOrAfter(Instant scheduledOnOrAfter) {
            this.scheduledOnOrAfter = scheduledOnOrAfter;
        }

        public final Instant getScheduledBefore() {
            return scheduledBefore;
        }

        @Override
        public final Builder scheduledBefore(Instant scheduledBefore) {
            this.scheduledBefore = scheduledBefore;
            return this;
        }

        public final void setScheduledBefore(Instant scheduledBefore) {
            this.scheduledBefore = scheduledBefore;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatasetContentsRequest build() {
            return new ListDatasetContentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
