/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreSummary.Builder, DatastoreSummary> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatastoreSummary::datastoreName)).setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()).build();

    private static final SdkField<DatastoreStorageSummary> DATASTORE_STORAGE_FIELD = SdkField
            .<DatastoreStorageSummary> builder(MarshallingType.SDK_POJO).getter(getter(DatastoreSummary::datastoreStorage))
            .setter(setter(Builder::datastoreStorage)).constructor(DatastoreStorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStorage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatastoreSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatastoreSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatastoreSummary::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            DATASTORE_STORAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datastoreName;

    private final DatastoreStorageSummary datastoreStorage;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private DatastoreSummary(BuilderImpl builder) {
        this.datastoreName = builder.datastoreName;
        this.datastoreStorage = builder.datastoreStorage;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the data store.
     * </p>
     * 
     * @return The name of the data store.
     */
    public String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * Where data store data is stored.
     * </p>
     * 
     * @return Where data store data is stored.
     */
    public DatastoreStorageSummary datastoreStorage() {
        return datastoreStorage;
    }

    /**
     * <p>
     * The status of the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data store.
     * @see DatastoreStatus
     */
    public DatastoreStatus status() {
        return DatastoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data store.
     * @see DatastoreStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the data store was created.
     * </p>
     * 
     * @return When the data store was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the data store was updated.
     * </p>
     * 
     * @return The last time the data store was updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStorage());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreSummary)) {
            return false;
        }
        DatastoreSummary other = (DatastoreSummary) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreStorage(), other.datastoreStorage())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatastoreSummary").add("DatastoreName", datastoreName())
                .add("DatastoreStorage", datastoreStorage()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "datastoreStorage":
            return Optional.ofNullable(clazz.cast(datastoreStorage()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreSummary, T> g) {
        return obj -> g.apply((DatastoreSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreSummary> {
        /**
         * <p>
         * The name of the data store.
         * </p>
         * 
         * @param datastoreName
         *        The name of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * Where data store data is stored.
         * </p>
         * 
         * @param datastoreStorage
         *        Where data store data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreStorage(DatastoreStorageSummary datastoreStorage);

        /**
         * <p>
         * Where data store data is stored.
         * </p>
         * This is a convenience that creates an instance of the {@link DatastoreStorageSummary.Builder} avoiding the
         * need to create one manually via {@link DatastoreStorageSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatastoreStorageSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #datastoreStorage(DatastoreStorageSummary)}.
         * 
         * @param datastoreStorage
         *        a consumer that will call methods on {@link DatastoreStorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastoreStorage(DatastoreStorageSummary)
         */
        default Builder datastoreStorage(Consumer<DatastoreStorageSummary.Builder> datastoreStorage) {
            return datastoreStorage(DatastoreStorageSummary.builder().applyMutation(datastoreStorage).build());
        }

        /**
         * <p>
         * The status of the data store.
         * </p>
         * 
         * @param status
         *        The status of the data store.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data store.
         * </p>
         * 
         * @param status
         *        The status of the data store.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder status(DatastoreStatus status);

        /**
         * <p>
         * When the data store was created.
         * </p>
         * 
         * @param creationTime
         *        When the data store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the data store was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the data store was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String datastoreName;

        private DatastoreStorageSummary datastoreStorage;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreSummary model) {
            datastoreName(model.datastoreName);
            datastoreStorage(model.datastoreStorage);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final DatastoreStorageSummary.Builder getDatastoreStorage() {
            return datastoreStorage != null ? datastoreStorage.toBuilder() : null;
        }

        @Override
        public final Builder datastoreStorage(DatastoreStorageSummary datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        public final void setDatastoreStorage(DatastoreStorageSummary.BuilderImpl datastoreStorage) {
            this.datastoreStorage = datastoreStorage != null ? datastoreStorage.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatastoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public DatastoreSummary build() {
            return new DatastoreSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
