/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A "DatasetAction" object that specifies how data set contents are automatically created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetAction implements SdkPojo, Serializable, ToCopyableBuilder<DatasetAction.Builder, DatasetAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetAction::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<SqlQueryDatasetAction> QUERY_ACTION_FIELD = SdkField
            .<SqlQueryDatasetAction> builder(MarshallingType.SDK_POJO).getter(getter(DatasetAction::queryAction))
            .setter(setter(Builder::queryAction)).constructor(SqlQueryDatasetAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryAction").build()).build();

    private static final SdkField<ContainerDatasetAction> CONTAINER_ACTION_FIELD = SdkField
            .<ContainerDatasetAction> builder(MarshallingType.SDK_POJO).getter(getter(DatasetAction::containerAction))
            .setter(setter(Builder::containerAction)).constructor(ContainerDatasetAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            QUERY_ACTION_FIELD, CONTAINER_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final SqlQueryDatasetAction queryAction;

    private final ContainerDatasetAction containerAction;

    private DatasetAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.queryAction = builder.queryAction;
        this.containerAction = builder.containerAction;
    }

    /**
     * <p>
     * The name of the data set action by which data set contents are automatically created.
     * </p>
     * 
     * @return The name of the data set action by which data set contents are automatically created.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
     * </p>
     * 
     * @return An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
     */
    public SqlQueryDatasetAction queryAction() {
        return queryAction;
    }

    /**
     * <p>
     * Information which allows the system to run a containerized application in order to create the data set contents.
     * The application must be in a Docker container along with any needed support libraries.
     * </p>
     * 
     * @return Information which allows the system to run a containerized application in order to create the data set
     *         contents. The application must be in a Docker container along with any needed support libraries.
     */
    public ContainerDatasetAction containerAction() {
        return containerAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(queryAction());
        hashCode = 31 * hashCode + Objects.hashCode(containerAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetAction)) {
            return false;
        }
        DatasetAction other = (DatasetAction) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(queryAction(), other.queryAction())
                && Objects.equals(containerAction(), other.containerAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatasetAction").add("ActionName", actionName()).add("QueryAction", queryAction())
                .add("ContainerAction", containerAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "queryAction":
            return Optional.ofNullable(clazz.cast(queryAction()));
        case "containerAction":
            return Optional.ofNullable(clazz.cast(containerAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetAction, T> g) {
        return obj -> g.apply((DatasetAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetAction> {
        /**
         * <p>
         * The name of the data set action by which data set contents are automatically created.
         * </p>
         * 
         * @param actionName
         *        The name of the data set action by which data set contents are automatically created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
         * </p>
         * 
         * @param queryAction
         *        An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAction(SqlQueryDatasetAction queryAction);

        /**
         * <p>
         * An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
         * </p>
         * This is a convenience that creates an instance of the {@link SqlQueryDatasetAction.Builder} avoiding the need
         * to create one manually via {@link SqlQueryDatasetAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlQueryDatasetAction.Builder#build()} is called immediately and
         * its result is passed to {@link #queryAction(SqlQueryDatasetAction)}.
         * 
         * @param queryAction
         *        a consumer that will call methods on {@link SqlQueryDatasetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryAction(SqlQueryDatasetAction)
         */
        default Builder queryAction(Consumer<SqlQueryDatasetAction.Builder> queryAction) {
            return queryAction(SqlQueryDatasetAction.builder().applyMutation(queryAction).build());
        }

        /**
         * <p>
         * Information which allows the system to run a containerized application in order to create the data set
         * contents. The application must be in a Docker container along with any needed support libraries.
         * </p>
         * 
         * @param containerAction
         *        Information which allows the system to run a containerized application in order to create the data set
         *        contents. The application must be in a Docker container along with any needed support libraries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerAction(ContainerDatasetAction containerAction);

        /**
         * <p>
         * Information which allows the system to run a containerized application in order to create the data set
         * contents. The application must be in a Docker container along with any needed support libraries.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerDatasetAction.Builder} avoiding the
         * need to create one manually via {@link ContainerDatasetAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerDatasetAction.Builder#build()} is called immediately and
         * its result is passed to {@link #containerAction(ContainerDatasetAction)}.
         * 
         * @param containerAction
         *        a consumer that will call methods on {@link ContainerDatasetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerAction(ContainerDatasetAction)
         */
        default Builder containerAction(Consumer<ContainerDatasetAction.Builder> containerAction) {
            return containerAction(ContainerDatasetAction.builder().applyMutation(containerAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private SqlQueryDatasetAction queryAction;

        private ContainerDatasetAction containerAction;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetAction model) {
            actionName(model.actionName);
            queryAction(model.queryAction);
            containerAction(model.containerAction);
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final SqlQueryDatasetAction.Builder getQueryAction() {
            return queryAction != null ? queryAction.toBuilder() : null;
        }

        @Override
        public final Builder queryAction(SqlQueryDatasetAction queryAction) {
            this.queryAction = queryAction;
            return this;
        }

        public final void setQueryAction(SqlQueryDatasetAction.BuilderImpl queryAction) {
            this.queryAction = queryAction != null ? queryAction.build() : null;
        }

        public final ContainerDatasetAction.Builder getContainerAction() {
            return containerAction != null ? containerAction.toBuilder() : null;
        }

        @Override
        public final Builder containerAction(ContainerDatasetAction containerAction) {
            this.containerAction = containerAction;
            return this;
        }

        public final void setContainerAction(ContainerDatasetAction.BuilderImpl containerAction) {
            this.containerAction = containerAction != null ? containerAction.build() : null;
        }

        @Override
        public DatasetAction build() {
            return new DatasetAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
