/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information needed to run the "containerAction" to produce data set contents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerDatasetAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerDatasetAction.Builder, ContainerDatasetAction> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDatasetAction::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDatasetAction::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<ResourceConfiguration> RESOURCE_CONFIGURATION_FIELD = SdkField
            .<ResourceConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ContainerDatasetAction::resourceConfiguration)).setter(setter(Builder::resourceConfiguration))
            .constructor(ResourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfiguration").build())
            .build();

    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField
            .<List<Variable>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDatasetAction::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Variable> builder(MarshallingType.SDK_POJO)
                                            .constructor(Variable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD,
            EXECUTION_ROLE_ARN_FIELD, RESOURCE_CONFIGURATION_FIELD, VARIABLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String image;

    private final String executionRoleArn;

    private final ResourceConfiguration resourceConfiguration;

    private final List<Variable> variables;

    private ContainerDatasetAction(BuilderImpl builder) {
        this.image = builder.image;
        this.executionRoleArn = builder.executionRoleArn;
        this.resourceConfiguration = builder.resourceConfiguration;
        this.variables = builder.variables;
    }

    /**
     * <p>
     * The ARN of the Docker container stored in your account. The Docker container contains an application and needed
     * support libraries and is used to generate data set contents.
     * </p>
     * 
     * @return The ARN of the Docker container stored in your account. The Docker container contains an application and
     *         needed support libraries and is used to generate data set contents.
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * The ARN of the role which gives permission to the system to access needed resources in order to run the
     * "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the input to
     * the containerized application.
     * </p>
     * 
     * @return The ARN of the role which gives permission to the system to access needed resources in order to run the
     *         "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the
     *         input to the containerized application.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Configuration of the resource which executes the "containerAction".
     * </p>
     * 
     * @return Configuration of the resource which executes the "containerAction".
     */
    public ResourceConfiguration resourceConfiguration() {
        return resourceConfiguration;
    }

    /**
     * Returns true if the Variables property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of variables used within the context of the execution of the containerized application (basically,
     * parameters passed to the application). Each variable must have a name and a value given by one of "stringValue",
     * "datasetContentVersionValue", or "outputFileUriValue".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values of variables used within the context of the execution of the containerized application
     *         (basically, parameters passed to the application). Each variable must have a name and a value given by
     *         one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
     */
    public List<Variable> variables() {
        return variables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDatasetAction)) {
            return false;
        }
        ContainerDatasetAction other = (ContainerDatasetAction) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(resourceConfiguration(), other.resourceConfiguration())
                && Objects.equals(variables(), other.variables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContainerDatasetAction").add("Image", image()).add("ExecutionRoleArn", executionRoleArn())
                .add("ResourceConfiguration", resourceConfiguration()).add("Variables", variables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "resourceConfiguration":
            return Optional.ofNullable(clazz.cast(resourceConfiguration()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDatasetAction, T> g) {
        return obj -> g.apply((ContainerDatasetAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerDatasetAction> {
        /**
         * <p>
         * The ARN of the Docker container stored in your account. The Docker container contains an application and
         * needed support libraries and is used to generate data set contents.
         * </p>
         * 
         * @param image
         *        The ARN of the Docker container stored in your account. The Docker container contains an application
         *        and needed support libraries and is used to generate data set contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The ARN of the role which gives permission to the system to access needed resources in order to run the
         * "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the
         * input to the containerized application.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the role which gives permission to the system to access needed resources in order to run
         *        the "containerAction". This includes, at minimum, permission to retrieve the data set contents which
         *        are the input to the containerized application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Configuration of the resource which executes the "containerAction".
         * </p>
         * 
         * @param resourceConfiguration
         *        Configuration of the resource which executes the "containerAction".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfiguration(ResourceConfiguration resourceConfiguration);

        /**
         * <p>
         * Configuration of the resource which executes the "containerAction".
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceConfiguration.Builder} avoiding the need
         * to create one manually via {@link ResourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceConfiguration(ResourceConfiguration)}.
         * 
         * @param resourceConfiguration
         *        a consumer that will call methods on {@link ResourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfiguration(ResourceConfiguration)
         */
        default Builder resourceConfiguration(Consumer<ResourceConfiguration.Builder> resourceConfiguration) {
            return resourceConfiguration(ResourceConfiguration.builder().applyMutation(resourceConfiguration).build());
        }

        /**
         * <p>
         * The values of variables used within the context of the execution of the containerized application (basically,
         * parameters passed to the application). Each variable must have a name and a value given by one of
         * "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
         * </p>
         * 
         * @param variables
         *        The values of variables used within the context of the execution of the containerized application
         *        (basically, parameters passed to the application). Each variable must have a name and a value given by
         *        one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<Variable> variables);

        /**
         * <p>
         * The values of variables used within the context of the execution of the containerized application (basically,
         * parameters passed to the application). Each variable must have a name and a value given by one of
         * "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
         * </p>
         * 
         * @param variables
         *        The values of variables used within the context of the execution of the containerized application
         *        (basically, parameters passed to the application). Each variable must have a name and a value given by
         *        one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Variable... variables);

        /**
         * <p>
         * The values of variables used within the context of the execution of the containerized application (basically,
         * parameters passed to the application). Each variable must have a name and a value given by one of
         * "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
         * </p>
         * This is a convenience that creates an instance of the {@link List<Variable>.Builder} avoiding the need to
         * create one manually via {@link List<Variable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Variable>.Builder#build()} is called immediately and its
         * result is passed to {@link #variables(List<Variable>)}.
         * 
         * @param variables
         *        a consumer that will call methods on {@link List<Variable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(List<Variable>)
         */
        Builder variables(Consumer<Variable.Builder>... variables);
    }

    static final class BuilderImpl implements Builder {
        private String image;

        private String executionRoleArn;

        private ResourceConfiguration resourceConfiguration;

        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDatasetAction model) {
            image(model.image);
            executionRoleArn(model.executionRoleArn);
            resourceConfiguration(model.resourceConfiguration);
            variables(model.variables);
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final ResourceConfiguration.Builder getResourceConfiguration() {
            return resourceConfiguration != null ? resourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfiguration(ResourceConfiguration resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            return this;
        }

        public final void setResourceConfiguration(ResourceConfiguration.BuilderImpl resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration != null ? resourceConfiguration.build() : null;
        }

        public final Collection<Variable.Builder> getVariables() {
            return variables != null ? variables.stream().map(Variable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariablesCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Variable... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder>... variables) {
            variables(Stream.of(variables).map(c -> Variable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariablesCopier.copyFromBuilder(variables);
        }

        @Override
        public ContainerDatasetAction build() {
            return new ContainerDatasetAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
