/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineSummary implements SdkPojo, Serializable, ToCopyableBuilder<PipelineSummary.Builder, PipelineSummary> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineSummary::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<List<ReprocessingSummary>> REPROCESSING_SUMMARIES_FIELD = SdkField
            .<List<ReprocessingSummary>> builder(MarshallingType.LIST)
            .getter(getter(PipelineSummary::reprocessingSummaries))
            .setter(setter(Builder::reprocessingSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reprocessingSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReprocessingSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReprocessingSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PipelineSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PipelineSummary::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            REPROCESSING_SUMMARIES_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineName;

    private final List<ReprocessingSummary> reprocessingSummaries;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private PipelineSummary(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.reprocessingSummaries = builder.reprocessingSummaries;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public String pipelineName() {
        return pipelineName;
    }

    /**
     * Returns true if the ReprocessingSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReprocessingSummaries() {
        return reprocessingSummaries != null && !(reprocessingSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of information about the pipeline reprocessing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReprocessingSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A summary of information about the pipeline reprocessing.
     */
    public List<ReprocessingSummary> reprocessingSummaries() {
        return reprocessingSummaries;
    }

    /**
     * <p>
     * When the pipeline was created.
     * </p>
     * 
     * @return When the pipeline was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the pipeline was last updated.
     * </p>
     * 
     * @return When the pipeline was last updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(reprocessingSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary) obj;
        return Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(reprocessingSummaries(), other.reprocessingSummaries())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PipelineSummary").add("PipelineName", pipelineName())
                .add("ReprocessingSummaries", reprocessingSummaries()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "reprocessingSummaries":
            return Optional.ofNullable(clazz.cast(reprocessingSummaries()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineSummary> {
        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * A summary of information about the pipeline reprocessing.
         * </p>
         * 
         * @param reprocessingSummaries
         *        A summary of information about the pipeline reprocessing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries);

        /**
         * <p>
         * A summary of information about the pipeline reprocessing.
         * </p>
         * 
         * @param reprocessingSummaries
         *        A summary of information about the pipeline reprocessing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reprocessingSummaries(ReprocessingSummary... reprocessingSummaries);

        /**
         * <p>
         * A summary of information about the pipeline reprocessing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReprocessingSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ReprocessingSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReprocessingSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #reprocessingSummaries(List<ReprocessingSummary>)}.
         * 
         * @param reprocessingSummaries
         *        a consumer that will call methods on {@link List<ReprocessingSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reprocessingSummaries(List<ReprocessingSummary>)
         */
        Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder>... reprocessingSummaries);

        /**
         * <p>
         * When the pipeline was created.
         * </p>
         * 
         * @param creationTime
         *        When the pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the pipeline was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        When the pipeline was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineName;

        private List<ReprocessingSummary> reprocessingSummaries = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            pipelineName(model.pipelineName);
            reprocessingSummaries(model.reprocessingSummaries);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Collection<ReprocessingSummary.Builder> getReprocessingSummaries() {
            return reprocessingSummaries != null ? reprocessingSummaries.stream().map(ReprocessingSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copy(reprocessingSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reprocessingSummaries(ReprocessingSummary... reprocessingSummaries) {
            reprocessingSummaries(Arrays.asList(reprocessingSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder>... reprocessingSummaries) {
            reprocessingSummaries(Stream.of(reprocessingSummaries)
                    .map(c -> ReprocessingSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReprocessingSummaries(Collection<ReprocessingSummary.BuilderImpl> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copyFromBuilder(reprocessingSummaries);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
