/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that adds information from the AWS IoT Device Shadows service to a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceShadowEnrichActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceShadowEnrichActivity.Builder, DeviceShadowEnrichActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceShadowEnrichActivity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceShadowEnrichActivity::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceShadowEnrichActivity::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceShadowEnrichActivity::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> NEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceShadowEnrichActivity::next)).setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTE_FIELD,
            THING_NAME_FIELD, ROLE_ARN_FIELD, NEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String attribute;

    private final String thingName;

    private final String roleArn;

    private final String next;

    private DeviceShadowEnrichActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.attribute = builder.attribute;
        this.thingName = builder.thingName;
        this.roleArn = builder.roleArn;
        this.next = builder.next;
    }

    /**
     * <p>
     * The name of the 'deviceShadowEnrich' activity.
     * </p>
     * 
     * @return The name of the 'deviceShadowEnrich' activity.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the attribute that is added to the message.
     * </p>
     * 
     * @return The name of the attribute that is added to the message.
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The name of the IoT device whose shadow information is added to the message.
     * </p>
     * 
     * @return The name of the IoT device whose shadow information is added to the message.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the role that allows access to the device's shadow.
     * </p>
     * 
     * @return The ARN of the role that allows access to the device's shadow.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The next activity in the pipeline.
     * </p>
     * 
     * @return The next activity in the pipeline.
     */
    public String next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(next());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceShadowEnrichActivity)) {
            return false;
        }
        DeviceShadowEnrichActivity other = (DeviceShadowEnrichActivity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(attribute(), other.attribute())
                && Objects.equals(thingName(), other.thingName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceShadowEnrichActivity").add("Name", name()).add("Attribute", attribute())
                .add("ThingName", thingName()).add("RoleArn", roleArn()).add("Next", next()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceShadowEnrichActivity, T> g) {
        return obj -> g.apply((DeviceShadowEnrichActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceShadowEnrichActivity> {
        /**
         * <p>
         * The name of the 'deviceShadowEnrich' activity.
         * </p>
         * 
         * @param name
         *        The name of the 'deviceShadowEnrich' activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute that is added to the message.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute that is added to the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The name of the IoT device whose shadow information is added to the message.
         * </p>
         * 
         * @param thingName
         *        The name of the IoT device whose shadow information is added to the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the role that allows access to the device's shadow.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that allows access to the device's shadow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The next activity in the pipeline.
         * </p>
         * 
         * @param next
         *        The next activity in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String next);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String attribute;

        private String thingName;

        private String roleArn;

        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceShadowEnrichActivity model) {
            name(model.name);
            attribute(model.attribute);
            thingName(model.thingName);
            roleArn(model.roleArn);
            next(model.next);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getNext() {
            return next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public DeviceShadowEnrichActivity build() {
            return new DeviceShadowEnrichActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
