/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePlacementResponse extends Iot1ClickProjectsResponse implements
        ToCopyableBuilder<DescribePlacementResponse.Builder, DescribePlacementResponse> {
    private static final SdkField<PlacementDescription> PLACEMENT_FIELD = SdkField
            .<PlacementDescription> builder(MarshallingType.SDK_POJO).getter(getter(DescribePlacementResponse::placement))
            .setter(setter(Builder::placement)).constructor(PlacementDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_FIELD));

    private final PlacementDescription placement;

    private DescribePlacementResponse(BuilderImpl builder) {
        super(builder);
        this.placement = builder.placement;
    }

    /**
     * <p>
     * An object describing the placement.
     * </p>
     * 
     * @return An object describing the placement.
     */
    public PlacementDescription placement() {
        return placement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementResponse)) {
            return false;
        }
        DescribePlacementResponse other = (DescribePlacementResponse) obj;
        return Objects.equals(placement(), other.placement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePlacementResponse").add("Placement", placement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "placement":
            return Optional.ofNullable(clazz.cast(placement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePlacementResponse, T> g) {
        return obj -> g.apply((DescribePlacementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePlacementResponse> {
        /**
         * <p>
         * An object describing the placement.
         * </p>
         * 
         * @param placement
         *        An object describing the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(PlacementDescription placement);

        /**
         * <p>
         * An object describing the placement.
         * </p>
         * This is a convenience that creates an instance of the {@link PlacementDescription.Builder} avoiding the need
         * to create one manually via {@link PlacementDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlacementDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #placement(PlacementDescription)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link PlacementDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(PlacementDescription)
         */
        default Builder placement(Consumer<PlacementDescription.Builder> placement) {
            return placement(PlacementDescription.builder().applyMutation(placement).build());
        }
    }

    static final class BuilderImpl extends Iot1ClickProjectsResponse.BuilderImpl implements Builder {
        private PlacementDescription placement;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementResponse model) {
            super(model);
            placement(model.placement);
        }

        public final PlacementDescription.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(PlacementDescription placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(PlacementDescription.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public DescribePlacementResponse build() {
            return new DescribePlacementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
