/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceMethodsResponse extends Iot1ClickDevicesResponse implements
        ToCopyableBuilder<GetDeviceMethodsResponse.Builder, GetDeviceMethodsResponse> {
    private static final SdkField<List<DeviceMethod>> DEVICE_METHODS_FIELD = SdkField
            .<List<DeviceMethod>> builder(MarshallingType.LIST)
            .memberName("DeviceMethods")
            .getter(getter(GetDeviceMethodsResponse::deviceMethods))
            .setter(setter(Builder::deviceMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceMethod> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceMethod::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_METHODS_FIELD));

    private final List<DeviceMethod> deviceMethods;

    private GetDeviceMethodsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceMethods = builder.deviceMethods;
    }

    /**
     * Returns true if the DeviceMethods property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDeviceMethods() {
        return deviceMethods != null && !(deviceMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of available device APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceMethods()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of available device APIs.
     */
    public final List<DeviceMethod> deviceMethods() {
        return deviceMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceMethods() ? deviceMethods() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceMethodsResponse)) {
            return false;
        }
        GetDeviceMethodsResponse other = (GetDeviceMethodsResponse) obj;
        return hasDeviceMethods() == other.hasDeviceMethods() && Objects.equals(deviceMethods(), other.deviceMethods());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceMethodsResponse").add("DeviceMethods", hasDeviceMethods() ? deviceMethods() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceMethods":
            return Optional.ofNullable(clazz.cast(deviceMethods()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceMethodsResponse, T> g) {
        return obj -> g.apply((GetDeviceMethodsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeviceMethodsResponse> {
        /**
         * <p>
         * List of available device APIs.
         * </p>
         * 
         * @param deviceMethods
         *        List of available device APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethods(Collection<DeviceMethod> deviceMethods);

        /**
         * <p>
         * List of available device APIs.
         * </p>
         * 
         * @param deviceMethods
         *        List of available device APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethods(DeviceMethod... deviceMethods);

        /**
         * <p>
         * List of available device APIs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceMethod>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceMethod>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceMethod>.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMethods(List<DeviceMethod>)}.
         * 
         * @param deviceMethods
         *        a consumer that will call methods on {@link List<DeviceMethod>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMethods(List<DeviceMethod>)
         */
        Builder deviceMethods(Consumer<DeviceMethod.Builder>... deviceMethods);
    }

    static final class BuilderImpl extends Iot1ClickDevicesResponse.BuilderImpl implements Builder {
        private List<DeviceMethod> deviceMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceMethodsResponse model) {
            super(model);
            deviceMethods(model.deviceMethods);
        }

        public final Collection<DeviceMethod.Builder> getDeviceMethods() {
            if (deviceMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceMethods != null ? deviceMethods.stream().map(DeviceMethod::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder deviceMethods(Collection<DeviceMethod> deviceMethods) {
            this.deviceMethods = ___listOfDeviceMethodCopier.copy(deviceMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceMethods(DeviceMethod... deviceMethods) {
            deviceMethods(Arrays.asList(deviceMethods));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceMethods(Consumer<DeviceMethod.Builder>... deviceMethods) {
            deviceMethods(Stream.of(deviceMethods).map(c -> DeviceMethod.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceMethods(Collection<DeviceMethod.BuilderImpl> deviceMethods) {
            this.deviceMethods = ___listOfDeviceMethodCopier.copyFromBuilder(deviceMethods);
        }

        @Override
        public GetDeviceMethodsResponse build() {
            return new GetDeviceMethodsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
