/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceEvent implements SdkPojo, Serializable, ToCopyableBuilder<DeviceEvent.Builder, DeviceEvent> {
    private static final SdkField<Device> DEVICE_FIELD = SdkField.<Device> builder(MarshallingType.SDK_POJO).memberName("Device")
            .getter(getter(DeviceEvent::device)).setter(setter(Builder::device)).constructor(Device::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final SdkField<String> STD_EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StdEvent").getter(getter(DeviceEvent::stdEvent)).setter(setter(Builder::stdEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stdEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEVICE_FIELD, STD_EVENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Device device;

    private final String stdEvent;

    private DeviceEvent(BuilderImpl builder) {
        this.device = builder.device;
        this.stdEvent = builder.stdEvent;
    }

    /**
     * <p>
     * An object representing the device associated with the event.
     * </p>
     * 
     * @return An object representing the device associated with the event.
     */
    public final Device device() {
        return device;
    }

    /**
     * <p>
     * A serialized JSON object representing the device-type specific event.
     * </p>
     * 
     * @return A serialized JSON object representing the device-type specific event.
     */
    public final String stdEvent() {
        return stdEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(stdEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceEvent)) {
            return false;
        }
        DeviceEvent other = (DeviceEvent) obj;
        return Objects.equals(device(), other.device()) && Objects.equals(stdEvent(), other.stdEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceEvent").add("Device", device()).add("StdEvent", stdEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        case "StdEvent":
            return Optional.ofNullable(clazz.cast(stdEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceEvent, T> g) {
        return obj -> g.apply((DeviceEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceEvent> {
        /**
         * <p>
         * An object representing the device associated with the event.
         * </p>
         * 
         * @param device
         *        An object representing the device associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * An object representing the device associated with the event.
         * </p>
         * This is a convenience that creates an instance of the {@link Device.Builder} avoiding the need to create one
         * manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().applyMutation(device).build());
        }

        /**
         * <p>
         * A serialized JSON object representing the device-type specific event.
         * </p>
         * 
         * @param stdEvent
         *        A serialized JSON object representing the device-type specific event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stdEvent(String stdEvent);
    }

    static final class BuilderImpl implements Builder {
        private Device device;

        private String stdEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceEvent model) {
            device(model.device);
            stdEvent(model.stdEvent);
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final String getStdEvent() {
            return stdEvent;
        }

        @Override
        public final Builder stdEvent(String stdEvent) {
            this.stdEvent = stdEvent;
            return this;
        }

        public final void setStdEvent(String stdEvent) {
            this.stdEvent = stdEvent;
        }

        @Override
        public DeviceEvent build() {
            return new DeviceEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
