/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ConfigurationDetails;
import software.amazon.awssdk.services.iot.model.EncryptionType;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEncryptionConfigurationResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeEncryptionConfigurationResponse> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionType").getter(DescribeEncryptionConfigurationResponse.getter(DescribeEncryptionConfigurationResponse::encryptionTypeAsString)).setter(DescribeEncryptionConfigurationResponse.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(DescribeEncryptionConfigurationResponse.getter(DescribeEncryptionConfigurationResponse::kmsKeyArn)).setter(DescribeEncryptionConfigurationResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> KMS_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsAccessRoleArn").getter(DescribeEncryptionConfigurationResponse.getter(DescribeEncryptionConfigurationResponse::kmsAccessRoleArn)).setter(DescribeEncryptionConfigurationResponse.setter(Builder::kmsAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccessRoleArn").build()}).build();
    private static final SdkField<ConfigurationDetails> CONFIGURATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationDetails").getter(DescribeEncryptionConfigurationResponse.getter(DescribeEncryptionConfigurationResponse::configurationDetails)).setter(DescribeEncryptionConfigurationResponse.setter(Builder::configurationDetails)).constructor(ConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationDetails").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeEncryptionConfigurationResponse.getter(DescribeEncryptionConfigurationResponse::lastModifiedDate)).setter(DescribeEncryptionConfigurationResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD, KMS_KEY_ARN_FIELD, KMS_ACCESS_ROLE_ARN_FIELD, CONFIGURATION_DETAILS_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEncryptionConfigurationResponse.memberNameToFieldInitializer();
    private final String encryptionType;
    private final String kmsKeyArn;
    private final String kmsAccessRoleArn;
    private final ConfigurationDetails configurationDetails;
    private final Instant lastModifiedDate;

    private DescribeEncryptionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.encryptionType = builder.encryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.kmsAccessRoleArn = builder.kmsAccessRoleArn;
        this.configurationDetails = builder.configurationDetails;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String kmsAccessRoleArn() {
        return this.kmsAccessRoleArn;
    }

    public final ConfigurationDetails configurationDetails() {
        return this.configurationDetails;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEncryptionConfigurationResponse)) {
            return false;
        }
        DescribeEncryptionConfigurationResponse other = (DescribeEncryptionConfigurationResponse)((Object)obj);
        return Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.kmsAccessRoleArn(), other.kmsAccessRoleArn()) && Objects.equals(this.configurationDetails(), other.configurationDetails()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEncryptionConfigurationResponse").add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("KmsAccessRoleArn", (Object)this.kmsAccessRoleArn()).add("ConfigurationDetails", (Object)this.configurationDetails()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "kmsAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.kmsAccessRoleArn()));
            }
            case "configurationDetails": {
                return Optional.ofNullable(clazz.cast(this.configurationDetails()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("kmsAccessRoleArn", KMS_ACCESS_ROLE_ARN_FIELD);
        map.put("configurationDetails", CONFIGURATION_DETAILS_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEncryptionConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeEncryptionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String encryptionType;
        private String kmsKeyArn;
        private String kmsAccessRoleArn;
        private ConfigurationDetails configurationDetails;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEncryptionConfigurationResponse model) {
            super(model);
            this.encryptionType(model.encryptionType);
            this.kmsKeyArn(model.kmsKeyArn);
            this.kmsAccessRoleArn(model.kmsAccessRoleArn);
            this.configurationDetails(model.configurationDetails);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getKmsAccessRoleArn() {
            return this.kmsAccessRoleArn;
        }

        public final void setKmsAccessRoleArn(String kmsAccessRoleArn) {
            this.kmsAccessRoleArn = kmsAccessRoleArn;
        }

        @Override
        public final Builder kmsAccessRoleArn(String kmsAccessRoleArn) {
            this.kmsAccessRoleArn = kmsAccessRoleArn;
            return this;
        }

        public final ConfigurationDetails.Builder getConfigurationDetails() {
            return this.configurationDetails != null ? this.configurationDetails.toBuilder() : null;
        }

        public final void setConfigurationDetails(ConfigurationDetails.BuilderImpl configurationDetails) {
            this.configurationDetails = configurationDetails != null ? configurationDetails.build() : null;
        }

        @Override
        public final Builder configurationDetails(ConfigurationDetails configurationDetails) {
            this.configurationDetails = configurationDetails;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeEncryptionConfigurationResponse build() {
            return new DescribeEncryptionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEncryptionConfigurationResponse> {
        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder kmsKeyArn(String var1);

        public Builder kmsAccessRoleArn(String var1);

        public Builder configurationDetails(ConfigurationDetails var1);

        default public Builder configurationDetails(Consumer<ConfigurationDetails.Builder> configurationDetails) {
            return this.configurationDetails((ConfigurationDetails)((ConfigurationDetails.Builder)ConfigurationDetails.builder().applyMutation(configurationDetails)).build());
        }

        public Builder lastModifiedDate(Instant var1);
    }
}

