/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListSbomValidationResultsRequest;
import software.amazon.awssdk.services.iot.model.ListSbomValidationResultsResponse;
import software.amazon.awssdk.services.iot.model.SbomValidationResultSummary;

public class ListSbomValidationResultsPublisher
implements SdkPublisher<ListSbomValidationResultsResponse> {
    private final IotAsyncClient client;
    private final ListSbomValidationResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSbomValidationResultsPublisher(IotAsyncClient client, ListSbomValidationResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSbomValidationResultsPublisher(IotAsyncClient client, ListSbomValidationResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSbomValidationResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSbomValidationResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SbomValidationResultSummary> validationResultSummaries() {
        Function<ListSbomValidationResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.validationResultSummaries() != null) {
                return response.validationResultSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSbomValidationResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSbomValidationResultsResponseFetcher
    implements AsyncPageFetcher<ListSbomValidationResultsResponse> {
        private ListSbomValidationResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSbomValidationResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSbomValidationResultsResponse> nextPage(ListSbomValidationResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSbomValidationResultsPublisher.this.client.listSbomValidationResults(ListSbomValidationResultsPublisher.this.firstRequest);
            }
            return ListSbomValidationResultsPublisher.this.client.listSbomValidationResults((ListSbomValidationResultsRequest)((Object)ListSbomValidationResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

