/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CommandExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandExecutionSummary> {
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandArn").getter(CommandExecutionSummary.getter(CommandExecutionSummary::commandArn)).setter(CommandExecutionSummary.setter(Builder::commandArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(CommandExecutionSummary.getter(CommandExecutionSummary::executionId)).setter(CommandExecutionSummary.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(CommandExecutionSummary.getter(CommandExecutionSummary::targetArn)).setter(CommandExecutionSummary.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CommandExecutionSummary.getter(CommandExecutionSummary::statusAsString)).setter(CommandExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CommandExecutionSummary.getter(CommandExecutionSummary::createdAt)).setter(CommandExecutionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(CommandExecutionSummary.getter(CommandExecutionSummary::startedAt)).setter(CommandExecutionSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(CommandExecutionSummary.getter(CommandExecutionSummary::completedAt)).setter(CommandExecutionSummary.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ARN_FIELD, EXECUTION_ID_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommandExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String commandArn;
    private final String executionId;
    private final String targetArn;
    private final String status;
    private final Instant createdAt;
    private final Instant startedAt;
    private final Instant completedAt;

    private CommandExecutionSummary(BuilderImpl builder) {
        this.commandArn = builder.commandArn;
        this.executionId = builder.executionId;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    public final String commandArn() {
        return this.commandArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final CommandExecutionStatus status() {
        return CommandExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandExecutionSummary)) {
            return false;
        }
        CommandExecutionSummary other = (CommandExecutionSummary)obj;
        return Objects.equals(this.commandArn(), other.commandArn()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CommandExecutionSummary").add("CommandArn", (Object)this.commandArn()).add("ExecutionId", (Object)this.executionId()).add("TargetArn", (Object)this.targetArn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commandArn": {
                return Optional.ofNullable(clazz.cast(this.commandArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandExecutionSummary, T> g) {
        return obj -> g.apply((CommandExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commandArn;
        private String executionId;
        private String targetArn;
        private String status;
        private Instant createdAt;
        private Instant startedAt;
        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandExecutionSummary model) {
            this.commandArn(model.commandArn);
            this.executionId(model.executionId);
            this.targetArn(model.targetArn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
        }

        public final String getCommandArn() {
            return this.commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public CommandExecutionSummary build() {
            return new CommandExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandExecutionSummary> {
        public Builder commandArn(String var1);

        public Builder executionId(String var1);

        public Builder targetArn(String var1);

        public Builder status(String var1);

        public Builder status(CommandExecutionStatus var1);

        public Builder createdAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);
    }
}

