/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.AuthorizerSummary;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;

public class ListAuthorizersPublisher
implements SdkPublisher<ListAuthorizersResponse> {
    private final IotAsyncClient client;
    private final ListAuthorizersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuthorizersPublisher(IotAsyncClient client, ListAuthorizersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuthorizersPublisher(IotAsyncClient client, ListAuthorizersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuthorizersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuthorizersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuthorizerSummary> authorizers() {
        Function<ListAuthorizersResponse, Iterator> getIterator = response -> {
            if (response != null && response.authorizers() != null) {
                return response.authorizers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuthorizersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuthorizersResponseFetcher
    implements AsyncPageFetcher<ListAuthorizersResponse> {
        private ListAuthorizersResponseFetcher() {
        }

        public boolean hasNextPage(ListAuthorizersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListAuthorizersResponse> nextPage(ListAuthorizersResponse previousPage) {
            if (previousPage == null) {
                return ListAuthorizersPublisher.this.client.listAuthorizers(ListAuthorizersPublisher.this.firstRequest);
            }
            return ListAuthorizersPublisher.this.client.listAuthorizers((ListAuthorizersRequest)((Object)ListAuthorizersPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

