/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoleAliasRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateRoleAliasRequest> {
    private static final SdkField<String> ROLE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleAlias").getter(UpdateRoleAliasRequest.getter(UpdateRoleAliasRequest::roleAlias)).setter(UpdateRoleAliasRequest.setter(Builder::roleAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("roleAlias").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateRoleAliasRequest.getter(UpdateRoleAliasRequest::roleArn)).setter(UpdateRoleAliasRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Integer> CREDENTIAL_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("credentialDurationSeconds").getter(UpdateRoleAliasRequest.getter(UpdateRoleAliasRequest::credentialDurationSeconds)).setter(UpdateRoleAliasRequest.setter(Builder::credentialDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialDurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_FIELD, ROLE_ARN_FIELD, CREDENTIAL_DURATION_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("roleAlias", ROLE_ALIAS_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("credentialDurationSeconds", CREDENTIAL_DURATION_SECONDS_FIELD);
        }
    });
    private final String roleAlias;
    private final String roleArn;
    private final Integer credentialDurationSeconds;

    private UpdateRoleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleArn = builder.roleArn;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
    }

    public final String roleAlias() {
        return this.roleAlias;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer credentialDurationSeconds() {
        return this.credentialDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialDurationSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoleAliasRequest)) {
            return false;
        }
        UpdateRoleAliasRequest other = (UpdateRoleAliasRequest)((Object)obj);
        return Objects.equals(this.roleAlias(), other.roleAlias()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.credentialDurationSeconds(), other.credentialDurationSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRoleAliasRequest").add("RoleAlias", (Object)this.roleAlias()).add("RoleArn", (Object)this.roleArn()).add("CredentialDurationSeconds", (Object)this.credentialDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleAlias": {
                return Optional.ofNullable(clazz.cast(this.roleAlias()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "credentialDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.credentialDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoleAliasRequest, T> g) {
        return obj -> g.apply((UpdateRoleAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String roleAlias;
        private String roleArn;
        private Integer credentialDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoleAliasRequest model) {
            super(model);
            this.roleAlias(model.roleAlias);
            this.roleArn(model.roleArn);
            this.credentialDurationSeconds(model.credentialDurationSeconds);
        }

        public final String getRoleAlias() {
            return this.roleAlias;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getCredentialDurationSeconds() {
            return this.credentialDurationSeconds;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoleAliasRequest build() {
            return new UpdateRoleAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoleAliasRequest> {
        public Builder roleAlias(String var1);

        public Builder roleArn(String var1);

        public Builder credentialDurationSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

