/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionsToExecuteListCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDetectMitigationActionsTaskRequest
extends IotRequest
implements ToCopyableBuilder<Builder, StartDetectMitigationActionsTaskRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::taskId)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()}).build();
    private static final SdkField<DetectMitigationActionsTaskTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::target)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::target)).constructor(DetectMitigationActionsTaskTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::actions)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ViolationEventOccurrenceRange> VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("violationEventOccurrenceRange").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::violationEventOccurrenceRange)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::violationEventOccurrenceRange)).constructor(ViolationEventOccurrenceRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventOccurrenceRange").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ONLY_ACTIVE_VIOLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeOnlyActiveViolations").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::includeOnlyActiveViolations)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::includeOnlyActiveViolations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOnlyActiveViolations").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SUPPRESSED_ALERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeSuppressedAlerts").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::includeSuppressedAlerts)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::includeSuppressedAlerts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSuppressedAlerts").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartDetectMitigationActionsTaskRequest.getter(StartDetectMitigationActionsTaskRequest::clientRequestToken)).setter(StartDetectMitigationActionsTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TARGET_FIELD, ACTIONS_FIELD, VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD, INCLUDE_ONLY_ACTIVE_VIOLATIONS_FIELD, INCLUDE_SUPPRESSED_ALERTS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("taskId", TASK_ID_FIELD);
            this.put("target", TARGET_FIELD);
            this.put("actions", ACTIONS_FIELD);
            this.put("violationEventOccurrenceRange", VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD);
            this.put("includeOnlyActiveViolations", INCLUDE_ONLY_ACTIVE_VIOLATIONS_FIELD);
            this.put("includeSuppressedAlerts", INCLUDE_SUPPRESSED_ALERTS_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        }
    });
    private final String taskId;
    private final DetectMitigationActionsTaskTarget target;
    private final List<String> actions;
    private final ViolationEventOccurrenceRange violationEventOccurrenceRange;
    private final Boolean includeOnlyActiveViolations;
    private final Boolean includeSuppressedAlerts;
    private final String clientRequestToken;

    private StartDetectMitigationActionsTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.target = builder.target;
        this.actions = builder.actions;
        this.violationEventOccurrenceRange = builder.violationEventOccurrenceRange;
        this.includeOnlyActiveViolations = builder.includeOnlyActiveViolations;
        this.includeSuppressedAlerts = builder.includeSuppressedAlerts;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final DetectMitigationActionsTaskTarget target() {
        return this.target;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final ViolationEventOccurrenceRange violationEventOccurrenceRange() {
        return this.violationEventOccurrenceRange;
    }

    public final Boolean includeOnlyActiveViolations() {
        return this.includeOnlyActiveViolations;
    }

    public final Boolean includeSuppressedAlerts() {
        return this.includeSuppressedAlerts;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventOccurrenceRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeOnlyActiveViolations());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSuppressedAlerts());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDetectMitigationActionsTaskRequest)) {
            return false;
        }
        StartDetectMitigationActionsTaskRequest other = (StartDetectMitigationActionsTaskRequest)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.target(), other.target()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.violationEventOccurrenceRange(), other.violationEventOccurrenceRange()) && Objects.equals(this.includeOnlyActiveViolations(), other.includeOnlyActiveViolations()) && Objects.equals(this.includeSuppressedAlerts(), other.includeSuppressedAlerts()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartDetectMitigationActionsTaskRequest").add("TaskId", (Object)this.taskId()).add("Target", (Object)this.target()).add("Actions", this.hasActions() ? this.actions() : null).add("ViolationEventOccurrenceRange", (Object)this.violationEventOccurrenceRange()).add("IncludeOnlyActiveViolations", (Object)this.includeOnlyActiveViolations()).add("IncludeSuppressedAlerts", (Object)this.includeSuppressedAlerts()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "violationEventOccurrenceRange": {
                return Optional.ofNullable(clazz.cast(this.violationEventOccurrenceRange()));
            }
            case "includeOnlyActiveViolations": {
                return Optional.ofNullable(clazz.cast(this.includeOnlyActiveViolations()));
            }
            case "includeSuppressedAlerts": {
                return Optional.ofNullable(clazz.cast(this.includeSuppressedAlerts()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartDetectMitigationActionsTaskRequest, T> g) {
        return obj -> g.apply((StartDetectMitigationActionsTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String taskId;
        private DetectMitigationActionsTaskTarget target;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private ViolationEventOccurrenceRange violationEventOccurrenceRange;
        private Boolean includeOnlyActiveViolations;
        private Boolean includeSuppressedAlerts;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDetectMitigationActionsTaskRequest model) {
            super(model);
            this.taskId(model.taskId);
            this.target(model.target);
            this.actions(model.actions);
            this.violationEventOccurrenceRange(model.violationEventOccurrenceRange);
            this.includeOnlyActiveViolations(model.includeOnlyActiveViolations);
            this.includeSuppressedAlerts(model.includeSuppressedAlerts);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final DetectMitigationActionsTaskTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(DetectMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DetectMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = DetectMitigationActionsToExecuteListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = DetectMitigationActionsToExecuteListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final ViolationEventOccurrenceRange.Builder getViolationEventOccurrenceRange() {
            return this.violationEventOccurrenceRange != null ? this.violationEventOccurrenceRange.toBuilder() : null;
        }

        public final void setViolationEventOccurrenceRange(ViolationEventOccurrenceRange.BuilderImpl violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange != null ? violationEventOccurrenceRange.build() : null;
        }

        @Override
        public final Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange;
            return this;
        }

        public final Boolean getIncludeOnlyActiveViolations() {
            return this.includeOnlyActiveViolations;
        }

        public final void setIncludeOnlyActiveViolations(Boolean includeOnlyActiveViolations) {
            this.includeOnlyActiveViolations = includeOnlyActiveViolations;
        }

        @Override
        public final Builder includeOnlyActiveViolations(Boolean includeOnlyActiveViolations) {
            this.includeOnlyActiveViolations = includeOnlyActiveViolations;
            return this;
        }

        public final Boolean getIncludeSuppressedAlerts() {
            return this.includeSuppressedAlerts;
        }

        public final void setIncludeSuppressedAlerts(Boolean includeSuppressedAlerts) {
            this.includeSuppressedAlerts = includeSuppressedAlerts;
        }

        @Override
        public final Builder includeSuppressedAlerts(Boolean includeSuppressedAlerts) {
            this.includeSuppressedAlerts = includeSuppressedAlerts;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDetectMitigationActionsTaskRequest build() {
            return new StartDetectMitigationActionsTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDetectMitigationActionsTaskRequest> {
        public Builder taskId(String var1);

        public Builder target(DetectMitigationActionsTaskTarget var1);

        default public Builder target(Consumer<DetectMitigationActionsTaskTarget.Builder> target) {
            return this.target((DetectMitigationActionsTaskTarget)((DetectMitigationActionsTaskTarget.Builder)DetectMitigationActionsTaskTarget.builder().applyMutation(target)).build());
        }

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange var1);

        default public Builder violationEventOccurrenceRange(Consumer<ViolationEventOccurrenceRange.Builder> violationEventOccurrenceRange) {
            return this.violationEventOccurrenceRange((ViolationEventOccurrenceRange)((ViolationEventOccurrenceRange.Builder)ViolationEventOccurrenceRange.builder().applyMutation(violationEventOccurrenceRange)).build());
        }

        public Builder includeOnlyActiveViolations(Boolean var1);

        public Builder includeSuppressedAlerts(Boolean var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

