/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Sbom;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSbomWithPackageVersionRequest
extends IotRequest
implements ToCopyableBuilder<Builder, AssociateSbomWithPackageVersionRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(AssociateSbomWithPackageVersionRequest.getter(AssociateSbomWithPackageVersionRequest::packageName)).setter(AssociateSbomWithPackageVersionRequest.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("packageName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(AssociateSbomWithPackageVersionRequest.getter(AssociateSbomWithPackageVersionRequest::versionName)).setter(AssociateSbomWithPackageVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionName").build()}).build();
    private static final SdkField<Sbom> SBOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sbom").getter(AssociateSbomWithPackageVersionRequest.getter(AssociateSbomWithPackageVersionRequest::sbom)).setter(AssociateSbomWithPackageVersionRequest.setter(Builder::sbom)).constructor(Sbom::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AssociateSbomWithPackageVersionRequest.getter(AssociateSbomWithPackageVersionRequest::clientToken)).setter(AssociateSbomWithPackageVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, VERSION_NAME_FIELD, SBOM_FIELD, CLIENT_TOKEN_FIELD));
    private final String packageName;
    private final String versionName;
    private final Sbom sbom;
    private final String clientToken;

    private AssociateSbomWithPackageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.sbom = builder.sbom;
        this.clientToken = builder.clientToken;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final Sbom sbom() {
        return this.sbom;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sbom());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSbomWithPackageVersionRequest)) {
            return false;
        }
        AssociateSbomWithPackageVersionRequest other = (AssociateSbomWithPackageVersionRequest)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.sbom(), other.sbom()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSbomWithPackageVersionRequest").add("PackageName", (Object)this.packageName()).add("VersionName", (Object)this.versionName()).add("Sbom", (Object)this.sbom()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "sbom": {
                return Optional.ofNullable(clazz.cast(this.sbom()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSbomWithPackageVersionRequest, T> g) {
        return obj -> g.apply((AssociateSbomWithPackageVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String packageName;
        private String versionName;
        private Sbom sbom;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSbomWithPackageVersionRequest model) {
            super(model);
            this.packageName(model.packageName);
            this.versionName(model.versionName);
            this.sbom(model.sbom);
            this.clientToken(model.clientToken);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final Sbom.Builder getSbom() {
            return this.sbom != null ? this.sbom.toBuilder() : null;
        }

        public final void setSbom(Sbom.BuilderImpl sbom) {
            this.sbom = sbom != null ? sbom.build() : null;
        }

        @Override
        public final Builder sbom(Sbom sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSbomWithPackageVersionRequest build() {
            return new AssociateSbomWithPackageVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSbomWithPackageVersionRequest> {
        public Builder packageName(String var1);

        public Builder versionName(String var1);

        public Builder sbom(Sbom var1);

        default public Builder sbom(Consumer<Sbom.Builder> sbom) {
            return this.sbom((Sbom)((Sbom.Builder)Sbom.builder().applyMutation(sbom)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

