/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.CACertificate;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;

public class ListCACertificatesIterable
implements SdkIterable<ListCaCertificatesResponse> {
    private final IotClient client;
    private final ListCaCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCACertificatesIterable(IotClient client, ListCaCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCaCertificatesResponseFetcher();
    }

    public Iterator<ListCaCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CACertificate> certificates() {
        Function<ListCaCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCaCertificatesResponseFetcher
    implements SyncPageFetcher<ListCaCertificatesResponse> {
        private ListCaCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCaCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListCaCertificatesResponse nextPage(ListCaCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListCACertificatesIterable.this.client.listCACertificates(ListCACertificatesIterable.this.firstRequest);
            }
            return ListCACertificatesIterable.this.client.listCACertificates((ListCaCertificatesRequest)((Object)ListCACertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

