/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CertificateMode {
    DEFAULT("DEFAULT"),
    SNI_ONLY("SNI_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CertificateMode> VALUE_MAP;
    private final String value;

    private CertificateMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CertificateMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CertificateMode> knownValues() {
        EnumSet<CertificateMode> knownValues = EnumSet.allOf(CertificateMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CertificateMode.class, CertificateMode::toString);
    }
}

