/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.StreamFile;
import software.amazon.awssdk.services.iot.model.StreamFilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateStreamRequest> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(UpdateStreamRequest.getter(UpdateStreamRequest::streamId)).setter(UpdateStreamRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("streamId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateStreamRequest.getter(UpdateStreamRequest::description)).setter(UpdateStreamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<StreamFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(UpdateStreamRequest.getter(UpdateStreamRequest::files)).setter(UpdateStreamRequest.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateStreamRequest.getter(UpdateStreamRequest::roleArn)).setter(UpdateStreamRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD, DESCRIPTION_FIELD, FILES_FIELD, ROLE_ARN_FIELD));
    private final String streamId;
    private final String description;
    private final List<StreamFile> files;
    private final String roleArn;

    private UpdateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamId = builder.streamId;
        this.description = builder.description;
        this.files = builder.files;
        this.roleArn = builder.roleArn;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<StreamFile> files() {
        return this.files;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamRequest)) {
            return false;
        }
        UpdateStreamRequest other = (UpdateStreamRequest)((Object)obj);
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.description(), other.description()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamRequest").add("StreamId", (Object)this.streamId()).add("Description", (Object)this.description()).add("Files", this.hasFiles() ? this.files() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamRequest, T> g) {
        return obj -> g.apply((UpdateStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String streamId;
        private String description;
        private List<StreamFile> files = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamRequest model) {
            super(model);
            this.streamId(model.streamId);
            this.description(model.description);
            this.files(model.files);
            this.roleArn(model.roleArn);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<StreamFile.Builder> getFiles() {
            List<StreamFile.Builder> result = StreamFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<StreamFile.BuilderImpl> files) {
            this.files = StreamFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<StreamFile> files) {
            this.files = StreamFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(StreamFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<StreamFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (StreamFile)((StreamFile.Builder)StreamFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamRequest build() {
            return new UpdateStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamRequest> {
        public Builder streamId(String var1);

        public Builder description(String var1);

        public Builder files(Collection<StreamFile> var1);

        public Builder files(StreamFile ... var1);

        public Builder files(Consumer<StreamFile.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

