/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.JobExecutionStatus;
import software.amazon.awssdk.services.iot.model.JobExecutionStatusDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecution> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobExecution.getter(JobExecution::jobId)).setter(JobExecution.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobExecution.getter(JobExecution::statusAsString)).setter(JobExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> FORCE_CANCELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceCanceled").getter(JobExecution.getter(JobExecution::forceCanceled)).setter(JobExecution.setter(Builder::forceCanceled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceCanceled").build()}).build();
    private static final SdkField<JobExecutionStatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(JobExecution.getter(JobExecution::statusDetails)).setter(JobExecution.setter(Builder::statusDetails)).constructor(JobExecutionStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingArn").getter(JobExecution.getter(JobExecution::thingArn)).setter(JobExecution.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()}).build();
    private static final SdkField<Instant> QUEUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("queuedAt").getter(JobExecution.getter(JobExecution::queuedAt)).setter(JobExecution.setter(Builder::queuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(JobExecution.getter(JobExecution::startedAt)).setter(JobExecution.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(JobExecution.getter(JobExecution::lastUpdatedAt)).setter(JobExecution.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionNumber").getter(JobExecution.getter(JobExecution::executionNumber)).setter(JobExecution.setter(Builder::executionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(JobExecution.getter(JobExecution::versionNumber)).setter(JobExecution.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final SdkField<Long> APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("approximateSecondsBeforeTimedOut").getter(JobExecution.getter(JobExecution::approximateSecondsBeforeTimedOut)).setter(JobExecution.setter(Builder::approximateSecondsBeforeTimedOut)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateSecondsBeforeTimedOut").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD, FORCE_CANCELED_FIELD, STATUS_DETAILS_FIELD, THING_ARN_FIELD, QUEUED_AT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, EXECUTION_NUMBER_FIELD, VERSION_NUMBER_FIELD, APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String status;
    private final Boolean forceCanceled;
    private final JobExecutionStatusDetails statusDetails;
    private final String thingArn;
    private final Instant queuedAt;
    private final Instant startedAt;
    private final Instant lastUpdatedAt;
    private final Long executionNumber;
    private final Long versionNumber;
    private final Long approximateSecondsBeforeTimedOut;

    private JobExecution(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.forceCanceled = builder.forceCanceled;
        this.statusDetails = builder.statusDetails;
        this.thingArn = builder.thingArn;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.executionNumber = builder.executionNumber;
        this.versionNumber = builder.versionNumber;
        this.approximateSecondsBeforeTimedOut = builder.approximateSecondsBeforeTimedOut;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean forceCanceled() {
        return this.forceCanceled;
    }

    public final JobExecutionStatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final String thingArn() {
        return this.thingArn;
    }

    public final Instant queuedAt() {
        return this.queuedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Long executionNumber() {
        return this.executionNumber;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final Long approximateSecondsBeforeTimedOut() {
        return this.approximateSecondsBeforeTimedOut;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceCanceled());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateSecondsBeforeTimedOut());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecution)) {
            return false;
        }
        JobExecution other = (JobExecution)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.forceCanceled(), other.forceCanceled()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.queuedAt(), other.queuedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.executionNumber(), other.executionNumber()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.approximateSecondsBeforeTimedOut(), other.approximateSecondsBeforeTimedOut());
    }

    public final String toString() {
        return ToString.builder((String)"JobExecution").add("JobId", (Object)this.jobId()).add("Status", (Object)this.statusAsString()).add("ForceCanceled", (Object)this.forceCanceled()).add("StatusDetails", (Object)this.statusDetails()).add("ThingArn", (Object)this.thingArn()).add("QueuedAt", (Object)this.queuedAt()).add("StartedAt", (Object)this.startedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ExecutionNumber", (Object)this.executionNumber()).add("VersionNumber", (Object)this.versionNumber()).add("ApproximateSecondsBeforeTimedOut", (Object)this.approximateSecondsBeforeTimedOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "forceCanceled": {
                return Optional.ofNullable(clazz.cast(this.forceCanceled()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "queuedAt": {
                return Optional.ofNullable(clazz.cast(this.queuedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "executionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "approximateSecondsBeforeTimedOut": {
                return Optional.ofNullable(clazz.cast(this.approximateSecondsBeforeTimedOut()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecution, T> g) {
        return obj -> g.apply((JobExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String status;
        private Boolean forceCanceled;
        private JobExecutionStatusDetails statusDetails;
        private String thingArn;
        private Instant queuedAt;
        private Instant startedAt;
        private Instant lastUpdatedAt;
        private Long executionNumber;
        private Long versionNumber;
        private Long approximateSecondsBeforeTimedOut;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecution model) {
            this.jobId(model.jobId);
            this.status(model.status);
            this.forceCanceled(model.forceCanceled);
            this.statusDetails(model.statusDetails);
            this.thingArn(model.thingArn);
            this.queuedAt(model.queuedAt);
            this.startedAt(model.startedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.executionNumber(model.executionNumber);
            this.versionNumber(model.versionNumber);
            this.approximateSecondsBeforeTimedOut(model.approximateSecondsBeforeTimedOut);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getForceCanceled() {
            return this.forceCanceled;
        }

        public final void setForceCanceled(Boolean forceCanceled) {
            this.forceCanceled = forceCanceled;
        }

        @Override
        @Transient
        public final Builder forceCanceled(Boolean forceCanceled) {
            this.forceCanceled = forceCanceled;
            return this;
        }

        public final JobExecutionStatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(JobExecutionStatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder statusDetails(JobExecutionStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        @Transient
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final Instant getQueuedAt() {
            return this.queuedAt;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        @Override
        @Transient
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        @Transient
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        @Transient
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        @Transient
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final Long getApproximateSecondsBeforeTimedOut() {
            return this.approximateSecondsBeforeTimedOut;
        }

        public final void setApproximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
        }

        @Override
        @Transient
        public final Builder approximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
            return this;
        }

        public JobExecution build() {
            return new JobExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecution> {
        public Builder jobId(String var1);

        public Builder status(String var1);

        public Builder status(JobExecutionStatus var1);

        public Builder forceCanceled(Boolean var1);

        public Builder statusDetails(JobExecutionStatusDetails var1);

        default public Builder statusDetails(Consumer<JobExecutionStatusDetails.Builder> statusDetails) {
            return this.statusDetails((JobExecutionStatusDetails)((JobExecutionStatusDetails.Builder)JobExecutionStatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder thingArn(String var1);

        public Builder queuedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder executionNumber(Long var1);

        public Builder versionNumber(Long var1);

        public Builder approximateSecondsBeforeTimedOut(Long var1);
    }
}

