/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.ClientPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaAction> {
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationArn").getter(KafkaAction.getter(KafkaAction::destinationArn)).setter(KafkaAction.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()}).build();
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topic").getter(KafkaAction.getter(KafkaAction::topic)).setter(KafkaAction.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(KafkaAction.getter(KafkaAction::key)).setter(KafkaAction.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partition").getter(KafkaAction.getter(KafkaAction::partition)).setter(KafkaAction.setter(Builder::partition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("clientProperties").getter(KafkaAction.getter(KafkaAction::clientProperties)).setter(KafkaAction.setter(Builder::clientProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ARN_FIELD, TOPIC_FIELD, KEY_FIELD, PARTITION_FIELD, CLIENT_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationArn;
    private final String topic;
    private final String key;
    private final String partition;
    private final Map<String, String> clientProperties;

    private KafkaAction(BuilderImpl builder) {
        this.destinationArn = builder.destinationArn;
        this.topic = builder.topic;
        this.key = builder.key;
        this.partition = builder.partition;
        this.clientProperties = builder.clientProperties;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final String topic() {
        return this.topic;
    }

    public final String key() {
        return this.key;
    }

    public final String partition() {
        return this.partition;
    }

    public final boolean hasClientProperties() {
        return this.clientProperties != null && !(this.clientProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> clientProperties() {
        return this.clientProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.partition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientProperties() ? this.clientProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaAction)) {
            return false;
        }
        KafkaAction other = (KafkaAction)obj;
        return Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.topic(), other.topic()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.partition(), other.partition()) && this.hasClientProperties() == other.hasClientProperties() && Objects.equals(this.clientProperties(), other.clientProperties());
    }

    public final String toString() {
        return ToString.builder((String)"KafkaAction").add("DestinationArn", (Object)this.destinationArn()).add("Topic", (Object)this.topic()).add("Key", (Object)this.key()).add("Partition", (Object)this.partition()).add("ClientProperties", this.hasClientProperties() ? this.clientProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "partition": {
                return Optional.ofNullable(clazz.cast(this.partition()));
            }
            case "clientProperties": {
                return Optional.ofNullable(clazz.cast(this.clientProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaAction, T> g) {
        return obj -> g.apply((KafkaAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationArn;
        private String topic;
        private String key;
        private String partition;
        private Map<String, String> clientProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaAction model) {
            this.destinationArn(model.destinationArn);
            this.topic(model.topic);
            this.key(model.key);
            this.partition(model.partition);
            this.clientProperties(model.clientProperties);
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getPartition() {
            return this.partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        public final Map<String, String> getClientProperties() {
            if (this.clientProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientProperties;
        }

        @Override
        public final Builder clientProperties(Map<String, String> clientProperties) {
            this.clientProperties = ClientPropertiesCopier.copy(clientProperties);
            return this;
        }

        public final void setClientProperties(Map<String, String> clientProperties) {
            this.clientProperties = ClientPropertiesCopier.copy(clientProperties);
        }

        public KafkaAction build() {
            return new KafkaAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaAction> {
        public Builder destinationArn(String var1);

        public Builder topic(String var1);

        public Builder key(String var1);

        public Builder partition(String var1);

        public Builder clientProperties(Map<String, String> var1);
    }
}

