/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.TargetViolationIdsForDetectMitigationActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectMitigationActionsTaskTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectMitigationActionsTaskTarget> {
    private static final SdkField<List<String>> VIOLATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("violationIds").getter(DetectMitigationActionsTaskTarget.getter(DetectMitigationActionsTaskTarget::violationIds)).setter(DetectMitigationActionsTaskTarget.setter(Builder::violationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileName").getter(DetectMitigationActionsTaskTarget.getter(DetectMitigationActionsTaskTarget::securityProfileName)).setter(DetectMitigationActionsTaskTarget.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> BEHAVIOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behaviorName").getter(DetectMitigationActionsTaskTarget.getter(DetectMitigationActionsTaskTarget::behaviorName)).setter(DetectMitigationActionsTaskTarget.setter(Builder::behaviorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviorName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_IDS_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> violationIds;
    private final String securityProfileName;
    private final String behaviorName;

    private DetectMitigationActionsTaskTarget(BuilderImpl builder) {
        this.violationIds = builder.violationIds;
        this.securityProfileName = builder.securityProfileName;
        this.behaviorName = builder.behaviorName;
    }

    public boolean hasViolationIds() {
        return this.violationIds != null && !(this.violationIds instanceof SdkAutoConstructList);
    }

    public List<String> violationIds() {
        return this.violationIds;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String behaviorName() {
        return this.behaviorName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolationIds() ? this.violationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionsTaskTarget)) {
            return false;
        }
        DetectMitigationActionsTaskTarget other = (DetectMitigationActionsTaskTarget)obj;
        return this.hasViolationIds() == other.hasViolationIds() && Objects.equals(this.violationIds(), other.violationIds()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.behaviorName(), other.behaviorName());
    }

    public String toString() {
        return ToString.builder((String)"DetectMitigationActionsTaskTarget").add("ViolationIds", this.hasViolationIds() ? this.violationIds() : null).add("SecurityProfileName", (Object)this.securityProfileName()).add("BehaviorName", (Object)this.behaviorName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "violationIds": {
                return Optional.ofNullable(clazz.cast(this.violationIds()));
            }
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "behaviorName": {
                return Optional.ofNullable(clazz.cast(this.behaviorName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionsTaskTarget, T> g) {
        return obj -> g.apply((DetectMitigationActionsTaskTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> violationIds = DefaultSdkAutoConstructList.getInstance();
        private String securityProfileName;
        private String behaviorName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionsTaskTarget model) {
            this.violationIds(model.violationIds);
            this.securityProfileName(model.securityProfileName);
            this.behaviorName(model.behaviorName);
        }

        public final Collection<String> getViolationIds() {
            if (this.violationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.violationIds;
        }

        @Override
        public final Builder violationIds(Collection<String> violationIds) {
            this.violationIds = TargetViolationIdsForDetectMitigationActionsCopier.copy(violationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationIds(String ... violationIds) {
            this.violationIds(Arrays.asList(violationIds));
            return this;
        }

        public final void setViolationIds(Collection<String> violationIds) {
            this.violationIds = TargetViolationIdsForDetectMitigationActionsCopier.copy(violationIds);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getBehaviorName() {
            return this.behaviorName;
        }

        @Override
        public final Builder behaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
            return this;
        }

        public final void setBehaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
        }

        public DetectMitigationActionsTaskTarget build() {
            return new DetectMitigationActionsTaskTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectMitigationActionsTaskTarget> {
        public Builder violationIds(Collection<String> var1);

        public Builder violationIds(String ... var1);

        public Builder securityProfileName(String var1);

        public Builder behaviorName(String var1);
    }
}

