/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomMetricResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateCustomMetricResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(CreateCustomMetricResponse.getter(CreateCustomMetricResponse::metricName)).setter(CreateCustomMetricResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> METRIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricArn").getter(CreateCustomMetricResponse.getter(CreateCustomMetricResponse::metricArn)).setter(CreateCustomMetricResponse.setter(Builder::metricArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, METRIC_ARN_FIELD));
    private final String metricName;
    private final String metricArn;

    private CreateCustomMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricArn = builder.metricArn;
    }

    public String metricName() {
        return this.metricName;
    }

    public String metricArn() {
        return this.metricArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomMetricResponse)) {
            return false;
        }
        CreateCustomMetricResponse other = (CreateCustomMetricResponse)((Object)obj);
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricArn(), other.metricArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateCustomMetricResponse").add("MetricName", (Object)this.metricName()).add("MetricArn", (Object)this.metricArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "metricArn": {
                return Optional.ofNullable(clazz.cast(this.metricArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomMetricResponse, T> g) {
        return obj -> g.apply((CreateCustomMetricResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String metricName;
        private String metricArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomMetricResponse model) {
            super(model);
            this.metricName(model.metricName);
            this.metricArn(model.metricArn);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricArn() {
            return this.metricArn;
        }

        @Override
        public final Builder metricArn(String metricArn) {
            this.metricArn = metricArn;
            return this;
        }

        public final void setMetricArn(String metricArn) {
            this.metricArn = metricArn;
        }

        @Override
        public CreateCustomMetricResponse build() {
            return new CreateCustomMetricResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomMetricResponse> {
        public Builder metricName(String var1);

        public Builder metricArn(String var1);
    }
}

