/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.MetricValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveViolation> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("violationId").getter(ActiveViolation.getter(ActiveViolation::violationId)).setter(ActiveViolation.setter(Builder::violationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(ActiveViolation.getter(ActiveViolation::thingName)).setter(ActiveViolation.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileName").getter(ActiveViolation.getter(ActiveViolation::securityProfileName)).setter(ActiveViolation.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build()}).build();
    private static final SdkField<Behavior> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("behavior").getter(ActiveViolation.getter(ActiveViolation::behavior)).setter(ActiveViolation.setter(Builder::behavior)).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final SdkField<MetricValue> LAST_VIOLATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastViolationValue").getter(ActiveViolation.getter(ActiveViolation::lastViolationValue)).setter(ActiveViolation.setter(Builder::lastViolationValue)).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastViolationValue").build()}).build();
    private static final SdkField<Instant> LAST_VIOLATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastViolationTime").getter(ActiveViolation.getter(ActiveViolation::lastViolationTime)).setter(ActiveViolation.setter(Builder::lastViolationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastViolationTime").build()}).build();
    private static final SdkField<Instant> VIOLATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("violationStartTime").getter(ActiveViolation.getter(ActiveViolation::violationStartTime)).setter(ActiveViolation.setter(Builder::violationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD, THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_FIELD, LAST_VIOLATION_VALUE_FIELD, LAST_VIOLATION_TIME_FIELD, VIOLATION_START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String violationId;
    private final String thingName;
    private final String securityProfileName;
    private final Behavior behavior;
    private final MetricValue lastViolationValue;
    private final Instant lastViolationTime;
    private final Instant violationStartTime;

    private ActiveViolation(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.lastViolationValue = builder.lastViolationValue;
        this.lastViolationTime = builder.lastViolationTime;
        this.violationStartTime = builder.violationStartTime;
    }

    public String violationId() {
        return this.violationId;
    }

    public String thingName() {
        return this.thingName;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public Behavior behavior() {
        return this.behavior;
    }

    public MetricValue lastViolationValue() {
        return this.lastViolationValue;
    }

    public Instant lastViolationTime() {
        return this.lastViolationTime;
    }

    public Instant violationStartTime() {
        return this.violationStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.behavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastViolationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastViolationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationStartTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveViolation)) {
            return false;
        }
        ActiveViolation other = (ActiveViolation)obj;
        return Objects.equals(this.violationId(), other.violationId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.behavior(), other.behavior()) && Objects.equals(this.lastViolationValue(), other.lastViolationValue()) && Objects.equals(this.lastViolationTime(), other.lastViolationTime()) && Objects.equals(this.violationStartTime(), other.violationStartTime());
    }

    public String toString() {
        return ToString.builder((String)"ActiveViolation").add("ViolationId", (Object)this.violationId()).add("ThingName", (Object)this.thingName()).add("SecurityProfileName", (Object)this.securityProfileName()).add("Behavior", (Object)this.behavior()).add("LastViolationValue", (Object)this.lastViolationValue()).add("LastViolationTime", (Object)this.lastViolationTime()).add("ViolationStartTime", (Object)this.violationStartTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "violationId": {
                return Optional.ofNullable(clazz.cast(this.violationId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behavior()));
            }
            case "lastViolationValue": {
                return Optional.ofNullable(clazz.cast(this.lastViolationValue()));
            }
            case "lastViolationTime": {
                return Optional.ofNullable(clazz.cast(this.lastViolationTime()));
            }
            case "violationStartTime": {
                return Optional.ofNullable(clazz.cast(this.violationStartTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveViolation, T> g) {
        return obj -> g.apply((ActiveViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationId;
        private String thingName;
        private String securityProfileName;
        private Behavior behavior;
        private MetricValue lastViolationValue;
        private Instant lastViolationTime;
        private Instant violationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveViolation model) {
            this.violationId(model.violationId);
            this.thingName(model.thingName);
            this.securityProfileName(model.securityProfileName);
            this.behavior(model.behavior);
            this.lastViolationValue(model.lastViolationValue);
            this.lastViolationTime(model.lastViolationTime);
            this.violationStartTime(model.violationStartTime);
        }

        public final String getViolationId() {
            return this.violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final Behavior.Builder getBehavior() {
            return this.behavior != null ? this.behavior.toBuilder() : null;
        }

        @Override
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        public final MetricValue.Builder getLastViolationValue() {
            return this.lastViolationValue != null ? this.lastViolationValue.toBuilder() : null;
        }

        @Override
        public final Builder lastViolationValue(MetricValue lastViolationValue) {
            this.lastViolationValue = lastViolationValue;
            return this;
        }

        public final void setLastViolationValue(MetricValue.BuilderImpl lastViolationValue) {
            this.lastViolationValue = lastViolationValue != null ? lastViolationValue.build() : null;
        }

        public final Instant getLastViolationTime() {
            return this.lastViolationTime;
        }

        @Override
        public final Builder lastViolationTime(Instant lastViolationTime) {
            this.lastViolationTime = lastViolationTime;
            return this;
        }

        public final void setLastViolationTime(Instant lastViolationTime) {
            this.lastViolationTime = lastViolationTime;
        }

        public final Instant getViolationStartTime() {
            return this.violationStartTime;
        }

        @Override
        public final Builder violationStartTime(Instant violationStartTime) {
            this.violationStartTime = violationStartTime;
            return this;
        }

        public final void setViolationStartTime(Instant violationStartTime) {
            this.violationStartTime = violationStartTime;
        }

        public ActiveViolation build() {
            return new ActiveViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveViolation> {
        public Builder violationId(String var1);

        public Builder thingName(String var1);

        public Builder securityProfileName(String var1);

        public Builder behavior(Behavior var1);

        default public Builder behavior(Consumer<Behavior.Builder> behavior) {
            return this.behavior((Behavior)((Behavior.Builder)Behavior.builder().applyMutation(behavior)).build());
        }

        public Builder lastViolationValue(MetricValue var1);

        default public Builder lastViolationValue(Consumer<MetricValue.Builder> lastViolationValue) {
            return this.lastViolationValue((MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation(lastViolationValue)).build());
        }

        public Builder lastViolationTime(Instant var1);

        public Builder violationStartTime(Instant var1);
    }
}

