/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuditCheckConfiguration;
import software.amazon.awssdk.services.iot.model.AuditCheckConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.AuditNotificationTarget;
import software.amazon.awssdk.services.iot.model.AuditNotificationTargetConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.AuditNotificationType;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountAuditConfigurationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateAccountAuditConfigurationRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAccountAuditConfigurationRequest.getter(UpdateAccountAuditConfigurationRequest::roleArn)).setter(UpdateAccountAuditConfigurationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, AuditNotificationTarget>> AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateAccountAuditConfigurationRequest.getter(UpdateAccountAuditConfigurationRequest::auditNotificationTargetConfigurationsAsStrings)).setter(UpdateAccountAuditConfigurationRequest.setter(Builder::auditNotificationTargetConfigurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditNotificationTargetConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditNotificationTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AuditCheckConfiguration>> AUDIT_CHECK_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateAccountAuditConfigurationRequest.getter(UpdateAccountAuditConfigurationRequest::auditCheckConfigurations)).setter(UpdateAccountAuditConfigurationRequest.setter(Builder::auditCheckConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditCheckConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD, AUDIT_CHECK_CONFIGURATIONS_FIELD));
    private final String roleArn;
    private final Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations;
    private final Map<String, AuditCheckConfiguration> auditCheckConfigurations;

    private UpdateAccountAuditConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.auditNotificationTargetConfigurations = builder.auditNotificationTargetConfigurations;
        this.auditCheckConfigurations = builder.auditCheckConfigurations;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations() {
        return AuditNotificationTargetConfigurationsCopier.copyStringToEnum(this.auditNotificationTargetConfigurations);
    }

    public boolean hasAuditNotificationTargetConfigurations() {
        return this.auditNotificationTargetConfigurations != null && !(this.auditNotificationTargetConfigurations instanceof SdkAutoConstructMap);
    }

    public Map<String, AuditNotificationTarget> auditNotificationTargetConfigurationsAsStrings() {
        return this.auditNotificationTargetConfigurations;
    }

    public boolean hasAuditCheckConfigurations() {
        return this.auditCheckConfigurations != null && !(this.auditCheckConfigurations instanceof SdkAutoConstructMap);
    }

    public Map<String, AuditCheckConfiguration> auditCheckConfigurations() {
        return this.auditCheckConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditNotificationTargetConfigurationsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditCheckConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountAuditConfigurationRequest)) {
            return false;
        }
        UpdateAccountAuditConfigurationRequest other = (UpdateAccountAuditConfigurationRequest)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.auditNotificationTargetConfigurationsAsStrings(), other.auditNotificationTargetConfigurationsAsStrings()) && Objects.equals(this.auditCheckConfigurations(), other.auditCheckConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAccountAuditConfigurationRequest").add("RoleArn", (Object)this.roleArn()).add("AuditNotificationTargetConfigurations", this.auditNotificationTargetConfigurationsAsStrings()).add("AuditCheckConfigurations", this.auditCheckConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "auditNotificationTargetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.auditNotificationTargetConfigurationsAsStrings()));
            }
            case "auditCheckConfigurations": {
                return Optional.ofNullable(clazz.cast(this.auditCheckConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountAuditConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAccountAuditConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String roleArn;
        private Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AuditCheckConfiguration> auditCheckConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountAuditConfigurationRequest model) {
            super(model);
            this.roleArn(model.roleArn);
            this.auditNotificationTargetConfigurationsWithStrings(model.auditNotificationTargetConfigurations);
            this.auditCheckConfigurations(model.auditCheckConfigurations);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, AuditNotificationTarget.Builder> getAuditNotificationTargetConfigurations() {
            return this.auditNotificationTargetConfigurations != null ? CollectionUtils.mapValues(this.auditNotificationTargetConfigurations, AuditNotificationTarget::toBuilder) : null;
        }

        @Override
        public final Builder auditNotificationTargetConfigurationsWithStrings(Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier.copy(auditNotificationTargetConfigurations);
            return this;
        }

        @Override
        public final Builder auditNotificationTargetConfigurations(Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier.copyEnumToString(auditNotificationTargetConfigurations);
            return this;
        }

        public final void setAuditNotificationTargetConfigurations(Map<String, AuditNotificationTarget.BuilderImpl> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier.copyFromBuilder(auditNotificationTargetConfigurations);
        }

        public final Map<String, AuditCheckConfiguration.Builder> getAuditCheckConfigurations() {
            return this.auditCheckConfigurations != null ? CollectionUtils.mapValues(this.auditCheckConfigurations, AuditCheckConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copy(auditCheckConfigurations);
            return this;
        }

        public final void setAuditCheckConfigurations(Map<String, AuditCheckConfiguration.BuilderImpl> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copyFromBuilder(auditCheckConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountAuditConfigurationRequest build() {
            return new UpdateAccountAuditConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountAuditConfigurationRequest> {
        public Builder roleArn(String var1);

        public Builder auditNotificationTargetConfigurationsWithStrings(Map<String, AuditNotificationTarget> var1);

        public Builder auditNotificationTargetConfigurations(Map<AuditNotificationType, AuditNotificationTarget> var1);

        public Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

